/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.io.stream.StreamNetInput;
import com.github.steveice10.packetlib.io.stream.StreamNetOutput;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.chunks.PaletteType;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.packets.PacketUpdateLight;
import com.replaymod.replaystudio.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.lang3.tuple.Pair;

public class PacketChunkData {
    private Column column;
    private boolean isUnload;
    private int unloadX;
    private int unloadZ;

    public static PacketChunkData read(Packet packet, int sections) throws IOException {
        PacketChunkData chunkData = new PacketChunkData();
        try (Packet.Reader reader = packet.reader();){
            if (packet.atLeast(ProtocolVersion.v1_9)) {
                if (packet.getType() == PacketType.UnloadChunk) {
                    chunkData.readUnload(packet, reader);
                } else {
                    chunkData.readLoad(packet, reader, sections);
                }
            } else {
                chunkData.readLoad(packet, reader, sections);
            }
        }
        return chunkData;
    }

    public static PacketChunkData readUnload(Packet packet) throws IOException {
        PacketChunkData chunkData = new PacketChunkData();
        try (Packet.Reader reader = packet.reader();){
            chunkData.readUnload(packet, reader);
        }
        return chunkData;
    }

    public Packet write(PacketTypeRegistry registry) throws IOException {
        boolean atLeastV1_9 = registry.atLeast(ProtocolVersion.v1_9);
        PacketType packetType = atLeastV1_9 ? (this.isUnload ? PacketType.UnloadChunk : PacketType.ChunkData) : (!this.isUnload && this.column.looksLikeUnloadOnMC1_8() ? PacketType.BulkChunkData : PacketType.ChunkData);
        Packet packet = new Packet(registry, packetType);
        try (Packet.Writer writer = packet.overwrite();){
            if (atLeastV1_9) {
                if (this.isUnload) {
                    this.writeUnload(packet, writer);
                } else {
                    this.writeLoad(packet, writer);
                }
            } else if (packetType == PacketType.BulkChunkData) {
                if (packet.atLeast(ProtocolVersion.v1_8)) {
                    PacketChunkData.writeBulkV1_8(packet, writer, Collections.singletonList(this.column));
                } else {
                    PacketChunkData.writeBulkV1_7(packet, writer, Collections.singletonList(this.column));
                }
            } else {
                this.writeLoad(packet, writer);
            }
        }
        return packet;
    }

    public static List<Column> readBulk(Packet packet) throws IOException {
        try (Packet.Reader in = packet.reader();){
            if (packet.atLeast(ProtocolVersion.v1_8)) {
                List<Column> list = PacketChunkData.readBulkV1_8(packet, in);
                return list;
            }
            List<Column> list = PacketChunkData.readBulkV1_7(packet, in);
            return list;
        }
    }

    private static List<Column> readBulkV1_8(Packet packet, Packet.Reader in) throws IOException {
        int column;
        ArrayList<Column> result = new ArrayList<Column>();
        boolean skylight = in.readBoolean();
        int columns = in.readVarInt();
        int[] xs = new int[columns];
        int[] zs = new int[columns];
        BitSet[] masks = new BitSet[columns];
        int[] lengths = new int[columns];
        for (column = 0; column < columns; ++column) {
            int length;
            xs[column] = in.readInt();
            zs[column] = in.readInt();
            masks[column] = in.readBitSet();
            int nChunks = masks[column].cardinality();
            lengths[column] = length = nChunks * 10240 + (skylight ? nChunks * 2048 : 0) + 256;
        }
        for (column = 0; column < columns; ++column) {
            byte[] buf = new byte[lengths[column]];
            in.readBytes(buf);
            result.add(PacketChunkData.readColumn(packet, buf, xs[column], zs[column], true, skylight, masks[column], new BitSet(), null, null, false));
        }
        return result;
    }

    private static void writeBulkV1_8(Packet packet, Packet.Writer out, List<Column> columns) throws IOException {
        out.writeBoolean(columns.stream().anyMatch(Column::hasSkyLightV1_8));
        out.writeVarInt(columns.size());
        for (Column column : columns) {
            out.writeInt(column.x);
            out.writeInt(column.z);
            out.writeBitSet(column.getChunkMask());
        }
        for (Column column : columns) {
            PacketChunkData.writeColumn(packet, out, column, true);
        }
    }

    private static List<Column> readBulkV1_7(Packet packet, Packet.Reader in) throws IOException {
        ArrayList<Column> result = new ArrayList<Column>();
        int columns = in.readShort();
        int deflatedLength = in.readInt();
        boolean skylight = in.readBoolean();
        byte[] deflatedBytes = in.readBytes(deflatedLength);
        byte[] inflated = new byte[196864 * columns];
        Inflater inflater = new Inflater();
        inflater.setInput(deflatedBytes, 0, deflatedLength);
        try {
            inflater.inflate(inflated);
        }
        catch (DataFormatException e) {
            throw new IOException("Bad compressed data format");
        }
        finally {
            inflater.end();
        }
        int pos = 0;
        for (int count = 0; count < columns; ++count) {
            int x = in.readInt();
            int z = in.readInt();
            BitSet chunkMask = in.readBitSet();
            BitSet extendedChunkMask = in.readBitSet();
            int chunks = chunkMask.cardinality();
            int extended = extendedChunkMask.cardinality();
            int length = 8192 * chunks + 256 + 2048 * extended;
            if (skylight) {
                length += 2048 * chunks;
            }
            byte[] buf = new byte[length];
            System.arraycopy(inflated, pos, buf, 0, length);
            result.add(PacketChunkData.readColumn(packet, buf, x, z, true, skylight, chunkMask, extendedChunkMask, null, null, false));
            pos += length;
        }
        return result;
    }

    private static void writeBulkV1_7(Packet packet, Packet.Writer out, List<Column> columns) throws IOException {
        throw new UnsupportedOperationException("writeBulkV1_7 is not yet implemented");
    }

    public static PacketChunkData load(Column column) {
        PacketChunkData chunkData = new PacketChunkData();
        chunkData.column = column;
        return chunkData;
    }

    public static PacketChunkData unload(int chunkX, int chunkZ) {
        PacketChunkData chunkData = new PacketChunkData();
        chunkData.isUnload = true;
        chunkData.unloadX = chunkX;
        chunkData.unloadZ = chunkZ;
        chunkData.column = new Column(chunkX, chunkZ, new Chunk[16], new byte[256], null, null, null, false, null);
        return chunkData;
    }

    private PacketChunkData() {
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean isUnload() {
        return this.isUnload;
    }

    public int getUnloadX() {
        return this.unloadX;
    }

    public int getUnloadZ() {
        return this.unloadZ;
    }

    private void readUnload(Packet packet, NetInput in) throws IOException {
        this.isUnload = true;
        if (packet.atLeast(ProtocolVersion.v1_20_2)) {
            this.unloadZ = in.readInt();
            this.unloadX = in.readInt();
        } else {
            this.unloadX = in.readInt();
            this.unloadZ = in.readInt();
        }
    }

    private void writeUnload(Packet packet, Packet.Writer out) throws IOException {
        if (packet.atLeast(ProtocolVersion.v1_20_2)) {
            out.writeInt(this.unloadZ);
            out.writeInt(this.unloadX);
        } else {
            out.writeInt(this.unloadX);
            out.writeInt(this.unloadZ);
        }
    }

    private void readLoad(Packet packet, Packet.Reader in, int sections) throws IOException {
        byte[] data;
        BitSet chunkMask;
        int x = in.readInt();
        int z = in.readInt();
        boolean fullChunk = packet.atLeast(ProtocolVersion.v1_17) ? true : in.readBoolean();
        boolean useExistingLightData = fullChunk;
        if (packet.atLeast(ProtocolVersion.v1_16) && !packet.atLeast(ProtocolVersion.v1_16_2)) {
            useExistingLightData = in.readBoolean();
        }
        if (packet.atLeast(ProtocolVersion.v1_18)) {
            chunkMask = new BitSet();
            chunkMask.set(0, sections);
        } else {
            chunkMask = in.readBitSet();
        }
        BitSet extendedChunkMask = packet.atLeast(ProtocolVersion.v1_8) ? new BitSet() : BitSet.valueOf(new long[]{in.readUnsignedShort()});
        CompoundTag heightmaps = null;
        if (packet.atLeast(ProtocolVersion.v1_14)) {
            heightmaps = in.readNBT();
        }
        int[] biomes = null;
        if (packet.atLeast(ProtocolVersion.v1_15) && packet.olderThan(ProtocolVersion.v1_18) && fullChunk) {
            if (packet.atLeast(ProtocolVersion.v1_16_2)) {
                biomes = new int[in.readVarInt()];
                for (int i = 0; i < biomes.length; ++i) {
                    biomes[i] = in.readVarInt();
                }
            } else {
                biomes = in.readInts(1024);
            }
        }
        if (packet.atLeast(ProtocolVersion.v1_8)) {
            data = in.readBytes(in.readVarInt());
        } else {
            byte[] deflated = in.readBytes(in.readInt());
            int len = 12288 * chunkMask.cardinality();
            if (fullChunk) {
                len += 256;
            }
            data = new byte[len];
            Inflater inflater = new Inflater();
            inflater.setInput(deflated, 0, deflated.length);
            try {
                inflater.inflate(data);
            }
            catch (DataFormatException e) {
                throw new IOException("Bad compressed data format");
            }
            finally {
                inflater.end();
            }
        }
        this.column = PacketChunkData.readColumn(packet, data, x, z, fullChunk, false, chunkMask, extendedChunkMask, heightmaps, biomes, useExistingLightData);
        if (packet.atLeast(ProtocolVersion.v1_9_3)) {
            TileEntity[] tileEntities = new TileEntity[in.readVarInt()];
            for (int i = 0; i < tileEntities.length; ++i) {
                tileEntities[i] = new TileEntity(packet, in);
            }
            this.column.tileEntities = tileEntities;
        }
        if (packet.atLeast(ProtocolVersion.v1_18)) {
            this.column.lightData = PacketUpdateLight.readData(packet, in);
        }
        if (packet.atMost(ProtocolVersion.v1_8) && fullChunk && chunkMask.isEmpty()) {
            this.isUnload = true;
            this.unloadX = x;
            this.unloadZ = z;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLoad(Packet packet, Packet.Writer out) throws IOException {
        byte[] data;
        int len;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        StreamNetOutput netOut = new StreamNetOutput(byteOut);
        Pair<BitSet, BitSet> masks = PacketChunkData.writeColumn(packet, netOut, this.column, this.column.isFull());
        BitSet mask = (BitSet)masks.getKey();
        BitSet extendedMask = (BitSet)masks.getValue();
        out.writeInt(this.column.x);
        out.writeInt(this.column.z);
        if (packet.olderThan(ProtocolVersion.v1_17)) {
            out.writeBoolean(this.column.isFull());
        }
        if (packet.atLeast(ProtocolVersion.v1_16) && !packet.atLeast(ProtocolVersion.v1_16_2)) {
            out.writeBoolean(this.column.useExistingLightData);
        }
        if (packet.olderThan(ProtocolVersion.v1_18)) {
            out.writeBitSet(mask);
        }
        if (!packet.atLeast(ProtocolVersion.v1_8)) {
            out.writeBitSet(extendedMask);
        }
        if (packet.atLeast(ProtocolVersion.v1_14)) {
            out.writeNBT((Tag)this.column.heightMaps);
        }
        int[] biomes = this.column.biomes;
        if (packet.atLeast(ProtocolVersion.v1_15) && packet.olderThan(ProtocolVersion.v1_18) && biomes != null) {
            if (packet.atLeast(ProtocolVersion.v1_16_2)) {
                out.writeVarInt(biomes.length);
                for (int biome : biomes) {
                    out.writeVarInt(biome);
                }
            } else {
                out.writeInts(biomes);
            }
        }
        if (packet.atLeast(ProtocolVersion.v1_8)) {
            len = byteOut.size();
            data = byteOut.toByteArray();
        } else {
            Deflater deflater = new Deflater(-1);
            len = byteOut.size();
            data = new byte[len];
            try {
                deflater.setInput(byteOut.toByteArray(), 0, len);
                deflater.finish();
                len = deflater.deflate(data);
            }
            finally {
                deflater.end();
            }
        }
        out.writeVarInt(len);
        out.writeBytes(data, len);
        if (packet.atLeast(ProtocolVersion.v1_9_3)) {
            out.writeVarInt(this.column.tileEntities.length);
            for (TileEntity tileEntity : this.column.tileEntities) {
                tileEntity.write(packet, out);
            }
        }
        if (packet.atLeast(ProtocolVersion.v1_18)) {
            PacketUpdateLight.writeData(packet, out, this.column.lightData);
        }
    }

    private static Column readColumn(Packet packet, byte[] data, int x, int z, boolean fullChunk, boolean hasSkylight, BitSet mask, BitSet extendedMask, CompoundTag heightmaps, int[] biomes, boolean useExistingLightData) throws IOException {
        StreamNetInput in = new StreamNetInput(new ByteArrayInputStream(data));
        if (packet.atLeast(ProtocolVersion.v1_17)) {
            Chunk[] chunks = new Chunk[mask.length()];
            for (int index = 0; index < chunks.length; ++index) {
                if (!mask.get(index)) continue;
                chunks[index] = new Chunk(packet, in);
            }
            return new Column(x, z, chunks, null, null, heightmaps, biomes, useExistingLightData, null);
        }
        Throwable ex = null;
        Column column = null;
        try {
            int index;
            Chunk[] chunks = new Chunk[16];
            for (index = 0; index < chunks.length; ++index) {
                Chunk chunk;
                if (!mask.get(index)) continue;
                if (packet.atLeast(ProtocolVersion.v1_9)) {
                    chunk = new Chunk(packet, in);
                    if (packet.atMost(ProtocolVersion.v1_13_2)) {
                        chunk.blockLight = in.readBytes(2048);
                        chunk.skyLight = hasSkylight ? in.readBytes(2048) : null;
                    }
                } else {
                    chunk = new Chunk(packet);
                }
                chunks[index] = chunk;
            }
            if (!packet.atLeast(ProtocolVersion.v1_9)) {
                if (packet.atLeast(ProtocolVersion.v1_8)) {
                    for (Chunk chunk : chunks) {
                        if (chunk == null) continue;
                        chunk.blocks.storage = FlexibleStorage.from(packet.getRegistry(), 16, 4096, in.readLongs(1024));
                    }
                } else {
                    for (Chunk chunk : chunks) {
                        if (chunk == null) continue;
                        chunk.blocks.storage = FlexibleStorage.from(packet.getRegistry(), 8, 4096, in.readLongs(512));
                    }
                    for (Chunk chunk : chunks) {
                        if (chunk == null) continue;
                        PalettedStorage.access$102(chunk.blocks, in.readLongs(256));
                    }
                }
                for (Chunk chunk : chunks) {
                    if (chunk == null) continue;
                    chunk.blockLight = in.readBytes(2048);
                }
                if (hasSkylight) {
                    for (Chunk chunk : chunks) {
                        if (chunk == null) continue;
                        chunk.skyLight = in.readBytes(2048);
                    }
                }
                for (index = 0; index < chunks.length; ++index) {
                    if (!extendedMask.get(index)) continue;
                    if (chunks[index] == null) {
                        in.readLongs(256);
                        continue;
                    }
                    PalettedStorage.access$202(chunks[index].blocks, in.readLongs(256));
                }
            }
            byte[] biomeData = null;
            if (fullChunk && in.available() > 0 && !packet.atLeast(ProtocolVersion.v1_15)) {
                biomeData = in.readBytes(packet.atLeast(ProtocolVersion.v1_13) ? 1024 : 256);
            }
            column = new Column(x, z, chunks, biomeData, null, heightmaps, biomes, useExistingLightData, null);
        }
        catch (Throwable e) {
            ex = e;
        }
        if (!(in.available() <= 0 && ex == null || hasSkylight)) {
            return PacketChunkData.readColumn(packet, data, x, z, fullChunk, true, mask, extendedMask, heightmaps, biomes, useExistingLightData);
        }
        if (ex != null) {
            throw new IOException("Failed to read chunk data.", ex);
        }
        return column;
    }

    private static Pair<BitSet, BitSet> writeColumn(Packet packet, NetOutput out, Column column, boolean fullChunk) throws IOException {
        BitSet mask = new BitSet();
        BitSet extendedMask = new BitSet();
        Chunk[] chunks = column.chunks;
        for (int index = 0; index < chunks.length; ++index) {
            Chunk chunk = chunks[index];
            if (chunk == null) continue;
            mask.set(index);
            if (!packet.atLeast(ProtocolVersion.v1_9)) continue;
            chunk.write(packet, out);
            if (!packet.atMost(ProtocolVersion.v1_13_2)) continue;
            out.writeBytes(chunk.blockLight);
            if (chunk.skyLight == null) continue;
            out.writeBytes(chunk.skyLight);
        }
        if (!packet.atLeast(ProtocolVersion.v1_9)) {
            if (packet.atLeast(ProtocolVersion.v1_8)) {
                for (Chunk chunk : chunks) {
                    if (chunk == null) continue;
                    out.writeLongs(((PalettedStorage)chunk.blocks).storage.data);
                }
            } else {
                for (Chunk chunk : chunks) {
                    if (chunk == null) continue;
                    out.writeLongs(((PalettedStorage)chunk.blocks).storage.data);
                }
                for (Chunk chunk : chunks) {
                    if (chunk == null) continue;
                    out.writeLongs(chunk.blocks.metadata);
                }
            }
            for (Chunk chunk : chunks) {
                if (chunk == null) continue;
                out.writeBytes(chunk.blockLight);
            }
            for (Chunk chunk : chunks) {
                if (chunk == null || chunk.skyLight == null) continue;
                out.writeBytes(chunk.skyLight);
            }
            for (int index = 0; index < chunks.length; ++index) {
                if (chunks[index] == null || chunks[index].blocks.extended == null) continue;
                extendedMask.set(index);
                out.writeLongs(chunks[index].blocks.extended);
            }
        }
        if (fullChunk && column.biomeData != null && !packet.atLeast(ProtocolVersion.v1_15)) {
            out.writeBytes(column.biomeData);
        }
        return Pair.of((Object)mask, (Object)extendedMask);
    }

    public static class TileEntity {
        public byte xz;
        public short y;
        public int type;
        public CompoundTag tag;

        TileEntity(Packet packet, Packet.Reader in) throws IOException {
            if (packet.atLeast(ProtocolVersion.v1_18)) {
                this.xz = in.readByte();
                this.y = in.readShort();
                this.type = in.readVarInt();
            }
            this.tag = in.readNBT();
        }

        void write(Packet packet, Packet.Writer out) throws IOException {
            if (packet.atLeast(ProtocolVersion.v1_18)) {
                out.writeByte(this.xz);
                out.writeShort(this.y);
                out.writeVarInt(this.type);
            }
            out.writeNBT((Tag)this.tag);
        }
    }

    private static class LegacyStorage
    extends FlexibleStorage {
        protected LegacyStorage(int bitsPerEntry, int entries) {
            this(bitsPerEntry, entries, new long[entries * bitsPerEntry / 64]);
        }

        protected LegacyStorage(int bitsPerEntry, int entries, long[] data) {
            super(data, bitsPerEntry, entries);
        }

        @Override
        public int get(int index) {
            if (index < 0 || index > this.entries - 1) {
                throw new IndexOutOfBoundsException();
            }
            int bitIndex = index * this.bitsPerEntry;
            int longIndex = bitIndex / 64;
            int subIndex = bitIndex % 64;
            short value = (short)(this.data[longIndex] >>> subIndex & this.maxEntryValue);
            if (this.bitsPerEntry == 16) {
                return Short.reverseBytes(value);
            }
            if (this.bitsPerEntry == 8) {
                return value;
            }
            throw new AssertionError((Object)"LegacyStorage can only be 8 or 16 bits per entry.");
        }

        @Override
        public void set(int index, int value) {
            if (index < 0 || index > this.entries - 1) {
                throw new IndexOutOfBoundsException();
            }
            if (value < 0 || (long)value > this.maxEntryValue) {
                throw new IllegalArgumentException("Value cannot be outside of accepted range.");
            }
            if (this.bitsPerEntry == 16) {
                value = Short.reverseBytes((short)value);
            }
            int bitIndex = index * this.bitsPerEntry;
            int longIndex = bitIndex / 64;
            int subIndex = bitIndex % 64;
            this.data[longIndex] = this.data[longIndex] & (this.maxEntryValue << subIndex ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.maxEntryValue) << subIndex;
        }
    }

    private static class CompactFlexibleStorage
    extends FlexibleStorage {
        public CompactFlexibleStorage(int bitsPerEntry, int entries) {
            this(bitsPerEntry, entries, new long[CompactFlexibleStorage.roundToNearest(entries * bitsPerEntry, 64) / 64]);
        }

        public CompactFlexibleStorage(int bitsPerEntry, int entries, long[] data) {
            super(data, bitsPerEntry, entries);
        }

        private static int roundToNearest(int value, int roundTo) {
            int remainder;
            if (roundTo == 0) {
                return 0;
            }
            if (value == 0) {
                return roundTo;
            }
            if (value < 0) {
                roundTo *= -1;
            }
            return (remainder = value % roundTo) != 0 ? value + roundTo - remainder : value;
        }

        @Override
        public int get(int index) {
            if (index < 0 || index > this.entries - 1) {
                throw new IndexOutOfBoundsException();
            }
            if (this.bitsPerEntry == 0) {
                return 0;
            }
            int bitIndex = index * this.bitsPerEntry;
            int startIndex = bitIndex / 64;
            int endIndex = ((index + 1) * this.bitsPerEntry - 1) / 64;
            int startBitSubIndex = bitIndex % 64;
            if (startIndex == endIndex) {
                return (int)(this.data[startIndex] >>> startBitSubIndex & this.maxEntryValue);
            }
            int endBitSubIndex = 64 - startBitSubIndex;
            return (int)((this.data[startIndex] >>> startBitSubIndex | this.data[endIndex] << endBitSubIndex) & this.maxEntryValue);
        }

        @Override
        public void set(int index, int value) {
            if (index < 0 || index > this.entries - 1) {
                throw new IndexOutOfBoundsException();
            }
            if (value < 0 || (long)value > this.maxEntryValue) {
                throw new IllegalArgumentException("Value cannot be outside of accepted range.");
            }
            int bitIndex = index * this.bitsPerEntry;
            int startIndex = bitIndex / 64;
            int endIndex = ((index + 1) * this.bitsPerEntry - 1) / 64;
            int startBitSubIndex = bitIndex % 64;
            this.data[startIndex] = this.data[startIndex] & (this.maxEntryValue << startBitSubIndex ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.maxEntryValue) << startBitSubIndex;
            if (startIndex != endIndex) {
                int endBitSubIndex = 64 - startBitSubIndex;
                this.data[endIndex] = this.data[endIndex] >>> endBitSubIndex << endBitSubIndex | ((long)value & this.maxEntryValue) >> endBitSubIndex;
            }
        }
    }

    private static class PaddedFlexibleStorage
    extends FlexibleStorage {
        private final int entriesPerLong;

        public PaddedFlexibleStorage(int bitsPerEntry, int entries) {
            this(bitsPerEntry, entries, new long[PaddedFlexibleStorage.longsForEntries(bitsPerEntry, entries)]);
        }

        public PaddedFlexibleStorage(int bitsPerEntry, int entries, long[] data) {
            super(data, bitsPerEntry, entries);
            this.entriesPerLong = bitsPerEntry == 0 ? 0 : 64 / bitsPerEntry;
        }

        private static int longsForEntries(int bitsPerEntry, int entries) {
            if (bitsPerEntry == 0) {
                return 0;
            }
            int entriesPerLong = 64 / bitsPerEntry;
            return (entries + entriesPerLong - 1) / entriesPerLong;
        }

        @Override
        public int get(int index) {
            if (index < 0 || index > this.entries - 1) {
                throw new IndexOutOfBoundsException();
            }
            if (this.bitsPerEntry == 0) {
                return 0;
            }
            int blockIndex = index / this.entriesPerLong;
            int subIndex = index % this.entriesPerLong;
            int subIndexBits = subIndex * this.bitsPerEntry;
            return (int)(this.data[blockIndex] >>> subIndexBits & this.maxEntryValue);
        }

        @Override
        public void set(int index, int value) {
            if (index < 0 || index > this.entries - 1) {
                throw new IndexOutOfBoundsException();
            }
            if (value < 0 || (long)value > this.maxEntryValue) {
                throw new IllegalArgumentException("Value cannot be outside of accepted range.");
            }
            int blockIndex = index / this.entriesPerLong;
            int subIndex = index % this.entriesPerLong;
            int subIndexBits = subIndex * this.bitsPerEntry;
            this.data[blockIndex] = this.data[blockIndex] & (this.maxEntryValue << subIndexBits ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.maxEntryValue) << subIndexBits;
        }
    }

    private static abstract class FlexibleStorage {
        protected final long[] data;
        protected final int bitsPerEntry;
        protected final int entries;
        protected final long maxEntryValue;

        protected FlexibleStorage(long[] data, int bitsPerEntry, int entries) {
            this.data = data;
            this.bitsPerEntry = bitsPerEntry;
            this.entries = entries;
            this.maxEntryValue = (1L << this.bitsPerEntry) - 1L;
        }

        public abstract int get(int var1);

        public abstract void set(int var1, int var2);

        static FlexibleStorage empty(PacketTypeRegistry registry, int bitsPerEntry, int entries) {
            if (registry.atLeast(ProtocolVersion.v1_16)) {
                return new PaddedFlexibleStorage(bitsPerEntry, entries);
            }
            if (registry.atLeast(ProtocolVersion.v1_9)) {
                return new CompactFlexibleStorage(bitsPerEntry, entries);
            }
            return new LegacyStorage(bitsPerEntry, entries);
        }

        static FlexibleStorage from(PacketTypeRegistry registry, int bitsPerEntry, int entries, long[] data) {
            if (registry.atLeast(ProtocolVersion.v1_16)) {
                return new PaddedFlexibleStorage(bitsPerEntry, entries, data);
            }
            if (registry.atLeast(ProtocolVersion.v1_9)) {
                return new CompactFlexibleStorage(bitsPerEntry, entries, data);
            }
            return new LegacyStorage(bitsPerEntry, entries, data);
        }
    }

    public static class PalettedStorage {
        private final PaletteType type;
        private final PacketTypeRegistry registry;
        private int countDelta;
        private int bitsPerEntry;
        private List<Integer> states;
        private FlexibleStorage storage;
        private long[] metadata;
        private long[] extended;

        private PalettedStorage(PalettedStorage from) {
            this.type = from.type;
            this.registry = from.registry;
            this.countDelta = from.countDelta;
            this.bitsPerEntry = from.bitsPerEntry;
            if (from.states != null) {
                this.states = new ArrayList<Integer>(from.states);
            }
            if (from.storage != null) {
                this.storage = FlexibleStorage.from(this.registry, this.bitsPerEntry, from.storage.entries, (long[])from.storage.data.clone());
            }
            if (from.metadata != null) {
                this.metadata = (long[])from.metadata.clone();
            }
            if (from.extended != null) {
                this.extended = (long[])from.extended.clone();
            }
        }

        public PalettedStorage(PaletteType type, PacketTypeRegistry registry) {
            this.type = type;
            this.registry = registry;
            this.bitsPerEntry = type == PaletteType.BLOCKS ? 4 : 0;
            this.states = new ArrayList<Integer>();
            this.states.add(0);
            this.storage = FlexibleStorage.empty(registry, this.bitsPerEntry, type.size());
        }

        PalettedStorage(PaletteType type, Packet packet) {
            this.type = type;
            this.registry = packet.getRegistry();
            this.bitsPerEntry = packet.atLeast(ProtocolVersion.v1_8) ? 16 : 8;
        }

        PalettedStorage(PaletteType type, Packet packet, NetInput in) throws IOException {
            this.type = type;
            this.registry = packet.getRegistry();
            this.bitsPerEntry = in.readUnsignedByte();
            this.states = new ArrayList<Integer>();
            int stateCount = this.bitsPerEntry > type.highestBitsPerValue() && packet.atLeast(ProtocolVersion.v1_13) ? 0 : (this.bitsPerEntry == 0 && packet.atLeast(ProtocolVersion.v1_18) ? 1 : in.readVarInt());
            for (int i = 0; i < stateCount; ++i) {
                this.states.add(in.readVarInt());
            }
            this.storage = FlexibleStorage.from(this.registry, this.bitsPerEntry, type.size(), in.readLongs(in.readVarInt()));
        }

        void write(Packet packet, NetOutput out) throws IOException {
            out.writeByte(this.bitsPerEntry);
            if (this.bitsPerEntry == 0 && packet.atLeast(ProtocolVersion.v1_18)) {
                out.writeVarInt(this.states.get(0));
            } else if (this.bitsPerEntry <= this.type.highestBitsPerValue() || !packet.atLeast(ProtocolVersion.v1_13)) {
                out.writeVarInt(this.states.size());
                for (Integer state : this.states) {
                    out.writeVarInt(state);
                }
            }
            out.writeVarInt(this.storage.data.length);
            out.writeLongs(this.storage.data);
        }

        private int index(int x, int y, int z) {
            if (this.type == PaletteType.BIOMES) {
                return y << 4 | z << 2 | x;
            }
            return y << 8 | z << 4 | x;
        }

        public int get(int x, int y, int z) {
            if (this.bitsPerEntry == 0) {
                return this.states.get(0);
            }
            int id = this.storage.get(this.index(x, y, z));
            return this.bitsPerEntry <= this.type.highestBitsPerValue() ? (id >= 0 && id < this.states.size() ? this.states.get(id) : 0) : id;
        }

        public void set(int x, int y, int z, int state) {
            int id;
            int n = id = this.bitsPerEntry <= this.type.highestBitsPerValue() ? this.states.indexOf(state) : state;
            if (id == -1) {
                this.states.add(state);
                if (this.states.size() > 1 << this.bitsPerEntry) {
                    ++this.bitsPerEntry;
                    List<Integer> oldStates = this.states;
                    if (this.bitsPerEntry > this.type.highestBitsPerValue()) {
                        oldStates = new ArrayList<Integer>(this.states);
                        this.states.clear();
                        this.bitsPerEntry = this.registry.atLeast(ProtocolVersion.v1_16) ? 15 : (this.registry.atLeast(ProtocolVersion.v1_13) ? 14 : 13);
                        int bitsUsed = (1 << this.bitsPerEntry) - 1;
                        for (int i = 0; i < this.storage.entries; ++i) {
                            bitsUsed |= this.storage.get(i);
                        }
                        this.bitsPerEntry = 32 - Integer.numberOfLeadingZeros(bitsUsed);
                    }
                    FlexibleStorage oldStorage = this.storage;
                    this.storage = FlexibleStorage.empty(this.registry, this.bitsPerEntry, this.storage.entries);
                    for (int index = 0; index < this.storage.entries; ++index) {
                        this.storage.set(index, oldStorage.get(index));
                    }
                }
                int n2 = id = this.bitsPerEntry <= this.type.highestBitsPerValue() ? this.states.indexOf(state) : state;
            }
            if (this.bitsPerEntry == 0) {
                return;
            }
            int ind = this.index(x, y, z);
            int curr = this.storage.get(ind);
            if (state != 0 && curr == 0) {
                ++this.countDelta;
            } else if (state == 0 && curr != 0) {
                --this.countDelta;
            }
            if (this.bitsPerEntry > this.type.highestBitsPerValue() && (long)id > this.storage.maxEntryValue) {
                this.bitsPerEntry = 32 - Integer.numberOfLeadingZeros(id);
                FlexibleStorage oldStorage = this.storage;
                this.storage = FlexibleStorage.empty(this.registry, this.bitsPerEntry, this.storage.entries);
                for (int i = 0; i < this.storage.entries; ++i) {
                    this.storage.set(i, oldStorage.get(i));
                }
            }
            this.storage.set(ind, id);
        }

        public PalettedStorage copy() {
            return new PalettedStorage(this);
        }

        static /* synthetic */ long[] access$102(PalettedStorage x0, long[] x1) {
            x0.metadata = x1;
            return x1;
        }

        static /* synthetic */ long[] access$202(PalettedStorage x0, long[] x1) {
            x0.extended = x1;
            return x1;
        }
    }

    public static class Chunk {
        private final int blockCount;
        public final PalettedStorage blocks;
        public final PalettedStorage biomes;
        public byte[] blockLight;
        public byte[] skyLight;

        private Chunk(Chunk from) {
            this.blockCount = from.blockCount;
            this.blocks = from.blocks != null ? from.blocks.copy() : null;
            this.biomes = from.biomes != null ? from.biomes.copy() : null;
            this.blockLight = from.blockLight != null ? (byte[])from.blockLight.clone() : null;
            this.skyLight = from.skyLight != null ? (byte[])from.skyLight.clone() : null;
        }

        public Chunk(PacketTypeRegistry registry) {
            this.blockCount = 0;
            this.blocks = new PalettedStorage(PaletteType.BLOCKS, registry);
            this.biomes = registry.atLeast(ProtocolVersion.v1_18) ? new PalettedStorage(PaletteType.BIOMES, registry) : null;
        }

        Chunk(Packet packet) {
            this.blockCount = 0;
            this.blocks = new PalettedStorage(PaletteType.BLOCKS, packet);
            this.biomes = null;
        }

        Chunk(Packet packet, NetInput in) throws IOException {
            this.blockCount = packet.atLeast(ProtocolVersion.v1_14) ? in.readShort() : (short)0;
            this.blocks = new PalettedStorage(PaletteType.BLOCKS, packet, in);
            this.biomes = packet.atLeast(ProtocolVersion.v1_18) ? new PalettedStorage(PaletteType.BIOMES, packet, in) : null;
        }

        void write(Packet packet, NetOutput out) throws IOException {
            if (packet.atLeast(ProtocolVersion.v1_14)) {
                out.writeShort(this.blockCount + this.blocks.countDelta);
            }
            this.blocks.write(packet, out);
            if (this.biomes != null) {
                this.biomes.write(packet, out);
            }
        }

        public Chunk copy() {
            return new Chunk(this);
        }
    }

    public static class Column {
        public int x;
        public int z;
        public Chunk[] chunks;
        public byte[] biomeData;
        public TileEntity[] tileEntities;
        public CompoundTag heightMaps;
        public int[] biomes;
        public boolean useExistingLightData;
        public PacketUpdateLight.Data lightData;

        public Column(int x, int z, Chunk[] chunks, byte[] biomeData, TileEntity[] tileEntities, CompoundTag heightmaps, int[] biomes, boolean useExistingLightData, PacketUpdateLight.Data lightData) {
            this.x = x;
            this.z = z;
            this.chunks = chunks;
            this.biomeData = biomeData;
            this.tileEntities = tileEntities;
            this.heightMaps = heightmaps;
            this.biomes = biomes;
            this.useExistingLightData = useExistingLightData;
            this.lightData = lightData;
        }

        public boolean isFull() {
            return this.biomeData != null || this.biomes != null || this.lightData != null && this.tileEntities != null;
        }

        public boolean looksLikeUnloadOnMC1_8() {
            return this.isFull() && Utils.containsOnlyNull(this.chunks);
        }

        public BitSet getChunkMask() {
            BitSet mask = new BitSet();
            for (int index = 0; index < this.chunks.length; ++index) {
                if (this.chunks[index] == null) continue;
                mask.set(index);
            }
            return mask;
        }

        public boolean hasSkyLightV1_8() {
            for (Chunk chunk : this.chunks) {
                if (chunk == null || chunk.skyLight == null) continue;
                return true;
            }
            return false;
        }

        public static long coordToLong(int x, int z) {
            return (long)x << 32 | (long)z & 0xFFFFFFFFL;
        }

        public static int longToX(long v) {
            return (int)(v >> 32);
        }

        public static int longToZ(long v) {
            return (int)(v & 0xFFFFFFFFL);
        }

        public long coordToLong() {
            return Column.coordToLong(this.x, this.z);
        }
    }
}

