/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.registry.Registries;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class PacketConfigRegistries {
    public static void read(Packet packet, Registries registries) throws IOException {
        try (Packet.Reader in = packet.reader();){
            if (packet.atLeast(ProtocolVersion.v1_20_5)) {
                String registryName = in.readString();
                List<Pair> registryEntries = in.readList(() -> {
                    String key = in.readString();
                    CompoundTag value = in.readBoolean() ? in.readNBT() : null;
                    return Pair.of((Object)key, (Object)value);
                });
                if (registries.registriesMap == null) {
                    registries.registriesMap = new HashMap<String, List<Pair<String, Tag>>>();
                }
                registries.registriesMap.computeIfAbsent(registryName, it -> new ArrayList()).addAll(registryEntries);
            } else {
                registries.registriesTag = in.readNBT();
            }
        }
    }

    public static List<Packet> write(PacketTypeRegistry registry, Registries registries) throws IOException {
        if (registry.atLeast(ProtocolVersion.v1_20_5)) {
            if (registries.registriesMap == null) {
                return Collections.emptyList();
            }
            ArrayList<Packet> packets = new ArrayList<Packet>(registries.registriesMap.size());
            for (Map.Entry<String, List<Pair<String, Tag>>> registryEntry : registries.registriesMap.entrySet()) {
                Packet packet = new Packet(registry, PacketType.ConfigRegistries);
                try (Packet.Writer writer = packet.overwrite();){
                    writer.writeString(registryEntry.getKey());
                    writer.writeList(registryEntry.getValue(), entry -> {
                        writer.writeString((String)entry.getKey());
                        Tag value = (Tag)entry.getValue();
                        if (value != null) {
                            writer.writeBoolean(true);
                            writer.writeNBT(value);
                        } else {
                            writer.writeBoolean(false);
                        }
                    });
                }
                packets.add(packet);
            }
            return packets;
        }
        Packet packet = new Packet(registry, PacketType.ConfigRegistries);
        try (Packet.Writer writer = packet.overwrite();){
            writer.writeNBT((Tag)registries.registriesTag);
        }
        return Collections.singletonList(packet);
    }
}

