/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import java.io.IOException;

public class PacketEntityHeadLook {
    public static float getYaw(Packet packet) throws IOException {
        try (Packet.Reader in = packet.reader();){
            if (packet.atLeast(ProtocolVersion.v1_8)) {
                in.readVarInt();
            } else {
                in.readInt();
            }
            float f = (float)in.readByte() / 256.0f * 360.0f;
            return f;
        }
    }

    public static Packet write(PacketTypeRegistry registry, int entityId, float yaw) throws IOException {
        Packet packet = new Packet(registry, PacketType.EntityHeadLook);
        try (Packet.Writer out = packet.overwrite();){
            if (packet.atLeast(ProtocolVersion.v1_8)) {
                out.writeVarInt(entityId);
            } else {
                out.writeInt(entityId);
            }
            out.writeByte((int)(yaw / 360.0f * 256.0f));
        }
        return packet;
    }
}

