/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.rar.cache;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.buffer.Unpooled;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.io.stream.StreamNetOutput;
import com.replaymod.replaystudio.util.ByteBufExtNetOutput;
import com.replaymod.replaystudio.util.Utils;
import java.io.IOException;
import java.io.OutputStream;

public class WriteableCache {
    private final CountingOutputStream wrapper;
    private final NetOutput out;

    public WriteableCache(OutputStream out) {
        this.wrapper = new CountingOutputStream(out);
        this.out = new StreamNetOutput(this.wrapper);
    }

    public int index() {
        return this.wrapper.index;
    }

    public NetOutput write() {
        return this.out;
    }

    public Deferred deferred() {
        return new Deferred(Unpooled.buffer());
    }

    private static class CountingOutputStream
    extends OutputStream {
        private final OutputStream inner;
        private int index;

        private CountingOutputStream(OutputStream inner) {
            this.inner = inner;
        }

        @Override
        public void write(int i) throws IOException {
            this.inner.write(i);
            ++this.index;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.inner.write(b, off, len);
            this.index += len;
        }
    }

    public class Deferred
    extends ByteBufExtNetOutput {
        private Deferred(ByteBuf buf) {
            super(buf);
        }

        public int commit() throws IOException {
            int index = WriteableCache.this.index();
            Utils.writeBytes(WriteableCache.this.out, this.getBuf());
            this.getBuf().release();
            return index;
        }
    }
}

