/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.rar.containers;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.buffer.Unpooled;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetOutput;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.packets.PacketConfigRegistries;
import com.replaymod.replaystudio.protocol.packets.PacketConfigSelectKnownPacks;
import com.replaymod.replaystudio.protocol.packets.PacketJoinGame;
import com.replaymod.replaystudio.protocol.packets.PacketPlayerPositionRotation;
import com.replaymod.replaystudio.rar.PacketSink;
import com.replaymod.replaystudio.rar.cache.ReadableCache;
import com.replaymod.replaystudio.rar.cache.WriteableCache;
import com.replaymod.replaystudio.rar.containers.StateTree;
import com.replaymod.replaystudio.rar.state.Replay;
import com.replaymod.replaystudio.rar.state.World;
import com.replaymod.replaystudio.util.IPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WorldStateTree
extends StateTree<World> {
    private final PacketTypeRegistry registry;
    private final Replay replay;
    private ReadableCache cache;
    private World activeWorld;

    public WorldStateTree(PacketTypeRegistry registry, Replay replay, int index) {
        super(index);
        this.registry = registry;
        this.replay = replay;
    }

    @Override
    public void load(PacketSink sink, ReadableCache cache) throws IOException {
        this.cache = cache;
        super.load(sink, cache);
    }

    @Override
    public void unload(PacketSink sink, ReadableCache cache) throws IOException {
        if (this.activeWorld != null) {
            this.activeWorld.unload(sink, cache);
            this.activeWorld = null;
        }
        this.cache = null;
        super.unload(sink, cache);
    }

    @Override
    protected World read(NetInput in) throws IOException {
        return new World(this.registry, in);
    }

    @Override
    protected void discard(World value) {
    }

    private void ensureActiveWorld(World world) throws IOException {
        if (world == this.activeWorld) {
            return;
        }
        if (this.activeWorld != null) {
            this.activeWorld.unload(Packet::release, this.cache);
            this.activeWorld = null;
        }
        if (world != null) {
            world.load(Packet::release, this.cache);
            this.activeWorld = world;
        }
    }

    private World getWorldOrSwitch(PacketSink sink, int currentTimeStamp, int targetTime) throws IOException {
        World targetWorld;
        Map.Entry previousEntry = this.map.floorEntry(currentTimeStamp);
        Map.Entry targetEntry = this.map.floorEntry(targetTime);
        World previousWorld = previousEntry != null ? (World)previousEntry.getValue() : null;
        World world = targetWorld = targetEntry != null ? (World)targetEntry.getValue() : null;
        if (previousWorld == null && targetWorld == null) {
            return null;
        }
        this.ensureActiveWorld(previousWorld);
        if (previousWorld == targetWorld) {
            return targetWorld;
        }
        if (previousWorld != null) {
            previousWorld.unload(sink, this.cache);
        }
        this.activeWorld = targetWorld;
        if (targetWorld != null) {
            List<Packet> featuresChanged;
            if (this.registry.atLeast(ProtocolVersion.v1_20_2)) {
                featuresChanged = new ArrayList();
                this.replay.features.playOrRewind(featuresChanged::add, previousEntry != null ? previousEntry.getKey() : -1, targetEntry.getKey());
            } else {
                featuresChanged = Collections.emptyList();
            }
            if (previousWorld == null || !previousWorld.info.equals(targetWorld.info) || !featuresChanged.isEmpty()) {
                Packet packet2;
                boolean isRespawnSufficient;
                boolean bl = isRespawnSufficient = previousWorld != null && previousWorld.info.isRespawnSufficient(targetWorld.info);
                if (this.registry.atLeast(ProtocolVersion.v1_20_2)) {
                    boolean registriesChanged;
                    boolean bl2 = registriesChanged = previousWorld == null || !previousWorld.info.registries.equals(targetWorld.info.registries);
                    if (registriesChanged || !featuresChanged.isEmpty()) {
                        PacketTypeRegistry configRegistry = this.registry.withState(State.CONFIGURATION);
                        sink.accept(new Packet(this.registry, PacketType.Reconfigure));
                        if (registriesChanged) {
                            if (configRegistry.atLeast(ProtocolVersion.v1_20_5)) {
                                sink.accept(PacketConfigSelectKnownPacks.write(configRegistry, targetWorld.info.registries.enabledPacks));
                            }
                            PacketConfigRegistries.write(configRegistry, targetWorld.info.registries).forEach(sink);
                            this.replay.tags.play(packet -> {
                                assert (packet.getType() == PacketType.Tags);
                                sink.accept(new Packet(configRegistry, PacketType.ConfigTags, packet.getBuf()));
                            }, -1, targetTime);
                        }
                        if (!featuresChanged.isEmpty()) {
                            featuresChanged.forEach(sink);
                        }
                        sink.accept(new Packet(configRegistry, PacketType.ConfigFinish));
                        isRespawnSufficient = false;
                    }
                }
                if (!isRespawnSufficient) {
                    PacketJoinGame joinGame = targetWorld.info.toPacketJoinGame();
                    if (this.registry.olderThan(ProtocolVersion.v1_16)) {
                        joinGame.dimension = joinGame.dimension.equals("0") ? "-1" : "0";
                    }
                    sink.accept(joinGame.write(this.registry));
                    if (this.registry.olderThan(ProtocolVersion.v1_20_2)) {
                        this.replay.tags.play(sink, -1, targetTime);
                    }
                    if (this.registry.olderThan(ProtocolVersion.v1_18_2)) {
                        sink.accept(targetWorld.info.toRespawnPacket().write(this.registry));
                    }
                } else {
                    sink.accept(targetWorld.info.toRespawnPacket().write(this.registry));
                }
                if (this.registry.atLeast(ProtocolVersion.v1_18_2)) {
                    packet2 = new Packet(this.registry, PacketType.SpawnPosition);
                    try (Packet.Writer out = packet2.overwrite();){
                        out.writePosition(new IPosition(0, 0, 0));
                        out.writeFloat(0.0f);
                    }
                } else {
                    packet2 = new PacketPlayerPositionRotation().write(this.registry);
                }
                sink.accept(packet2);
            }
            targetWorld.load(sink, this.cache);
            targetWorld.play(sink, -1, targetTime);
        }
        return null;
    }

    @Override
    public void play(PacketSink sink, int currentTimeStamp, int targetTime) throws IOException {
        World world = this.getWorldOrSwitch(sink, currentTimeStamp, targetTime);
        if (world != null) {
            world.play(sink, currentTimeStamp, targetTime);
        }
    }

    @Override
    public void rewind(PacketSink sink, int currentTimeStamp, int targetTime) throws IOException {
        World world = this.getWorldOrSwitch(sink, currentTimeStamp, targetTime);
        if (world != null) {
            world.rewind(sink, currentTimeStamp, targetTime);
        }
    }

    public static class Builder {
        private final PacketTypeRegistry registry;
        private final WriteableCache cache;
        private final TreeBuilder builder = new TreeBuilder();
        public World.Builder world;

        public Builder(PacketTypeRegistry registry, WriteableCache cache) throws IOException {
            this.registry = registry;
            this.cache = cache;
        }

        public World.Builder newWorld(int time, World.Info info) throws IOException {
            World.Builder builder;
            this.world = builder = new World.Builder(this.registry, this.cache, info);
            this.builder.put(time, this.world);
            return builder;
        }

        public int build(int time) throws IOException {
            this.builder.endTime = time;
            return this.builder.build(this.cache);
        }

        private static class TreeBuilder
        extends StateTree.Builder<World.Builder> {
            private int endTime;

            private TreeBuilder() {
            }

            @Override
            protected void write(NetOutput out, World.Builder world, int time) throws IOException {
                Integer nextTime = this.map.higherKey(time);
                world.build(out, nextTime != null ? nextTime : this.endTime);
            }

            @Override
            protected void discard(World.Builder world) {
                ByteBuf buf = Unpooled.buffer();
                try {
                    world.build(new ByteBufNetOutput(buf), 0);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                buf.release();
            }
        }
    }
}

