/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.stream;

import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.filter.StreamFilter;
import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.lib.guava.base.Supplier;
import com.replaymod.replaystudio.lib.guava.collect.Lists;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.stream.PacketStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public abstract class AbstractPacketStream
implements PacketStream {
    private final Queue<PacketData> inserted = new LinkedList<PacketData>();
    private final List<StreamElement> filters = new ArrayList<StreamElement>();
    private StreamElement firstElement;

    public static AbstractPacketStream of(Supplier<PacketData> supplier) {
        return new AbstractPacketStreamImpl(supplier);
    }

    @Override
    public void insert(PacketData packet) {
        this.inserted.add(packet);
    }

    @Override
    public void insert(long time, Packet packet) {
        this.inserted.add(new PacketData(time, packet));
    }

    private void buildPipe() {
        Iterator<StreamElement> iter = this.filters.iterator();
        StreamElement l = null;
        while (iter.hasNext()) {
            StreamElement e = iter.next();
            if (l == null) {
                this.firstElement = e;
            } else {
                l.next = e;
            }
            l = e;
        }
        if (l == null) {
            this.firstElement = new StreamElementEnd();
        } else {
            l.next = (StreamElement)new StreamElementEnd();
        }
    }

    @Override
    public void addFilter(StreamFilter filter) {
        this.addFilter(filter, -1L, -1L);
    }

    @Override
    public void addFilter(StreamFilter filter, long from, long to) {
        this.filters.add(new StreamElement(new PacketStream.FilterInfo(filter, from, to)));
        this.buildPipe();
    }

    @Override
    public void removeFilter(StreamFilter filter) {
        Iterator<StreamElement> iter = this.filters.iterator();
        while (iter.hasNext()) {
            if (filter != iter.next().filter.getFilter()) continue;
            iter.remove();
        }
        this.buildPipe();
    }

    protected abstract PacketData nextInput();

    @Override
    public PacketData next() throws IOException {
        PacketData next;
        while (this.inserted.isEmpty() && (next = this.nextInput()) != null) {
            this.firstElement.process(next);
        }
        return this.inserted.poll();
    }

    @Override
    public Collection<PacketStream.FilterInfo> getFilters() {
        return Collections.unmodifiableList(Lists.transform(this.filters, e -> ((StreamElement)e).filter));
    }

    @Override
    public List<PacketData> end() throws IOException {
        this.firstElement.process(null);
        LinkedList<PacketData> result = new LinkedList<PacketData>(this.inserted);
        this.inserted.clear();
        return result;
    }

    protected abstract void cleanup();

    public String toString() {
        StringBuilder sb = new StringBuilder("PacketStream[");
        StreamElement e = this.firstElement;
        while (e != null) {
            sb.append(e);
            if (e.next != null) {
                sb.append(" -> ");
            }
            e = e.next;
        }
        sb.append("]");
        return sb.toString();
    }

    private class StreamElementEnd
    extends StreamElement {
        @Override
        public void process(PacketData data) {
            if (data != null) {
                AbstractPacketStream.this.inserted.add(data);
            }
        }

        @Override
        public String toString() {
            return "Out";
        }
    }

    private class StreamElement {
        private final PacketStream.FilterInfo filter;
        private final PacketStreamContext context;
        private final Queue<PacketData> inserted;
        private boolean active;
        private long lastTimestamp;
        private StreamElement next;

        protected StreamElement() {
            this.context = new PacketStreamContext(this);
            this.inserted = new LinkedList<PacketData>();
            this.filter = null;
        }

        public StreamElement(PacketStream.FilterInfo filter) {
            this.context = new PacketStreamContext(this);
            this.inserted = new LinkedList<PacketData>();
            this.filter = Preconditions.checkNotNull(filter);
        }

        public void process(PacketData data) throws IOException {
            boolean keep = true;
            if (data != null && this.filter.applies(data.getTime())) {
                if (!this.active) {
                    this.filter.getFilter().onStart(this.context);
                    this.active = true;
                }
                if (!(keep = this.filter.getFilter().onPacket(this.context, data))) {
                    data.getPacket().getBuf().release();
                }
            } else if (this.active) {
                this.filter.getFilter().onEnd(this.context, this.lastTimestamp);
                this.active = false;
                for (PacketData d : this.inserted) {
                    if (d.getTime() > this.lastTimestamp) {
                        this.lastTimestamp = d.getTime();
                    }
                    this.next.process(d);
                }
                this.inserted.clear();
            }
            if (data != null && keep) {
                if (data.getTime() > this.lastTimestamp) {
                    this.lastTimestamp = data.getTime();
                }
                this.next.process(data);
            }
            for (PacketData d : this.inserted) {
                if (d.getTime() > this.lastTimestamp) {
                    this.lastTimestamp = d.getTime();
                }
                this.next.process(d);
            }
            this.inserted.clear();
            if (data == null) {
                this.next.process(null);
            }
        }

        public String toString() {
            return (this.active ? "" : "in") + "active " + this.filter;
        }
    }

    private class PacketStreamContext
    implements PacketStream {
        private final StreamElement element;

        public PacketStreamContext(StreamElement element) {
            this.element = Preconditions.checkNotNull(element);
        }

        @Override
        public void insert(PacketData packet) {
            this.element.inserted.add(packet);
        }

        @Override
        public void insert(long time, Packet packet) {
            this.element.inserted.add(new PacketData(time, packet));
        }

        @Override
        public void addFilter(StreamFilter filter) {
            AbstractPacketStream.this.addFilter(filter);
        }

        @Override
        public void addFilter(StreamFilter filter, long from, long to) {
            AbstractPacketStream.this.addFilter(filter, from, to);
        }

        @Override
        public void removeFilter(StreamFilter filter) {
            AbstractPacketStream.this.removeFilter(filter);
        }

        @Override
        public Collection<PacketStream.FilterInfo> getFilters() {
            return AbstractPacketStream.this.getFilters();
        }

        @Override
        public PacketData next() {
            throw new IllegalStateException("Cannot get next data from within stream pipeline");
        }

        @Override
        public void start() {
            throw new IllegalStateException("Cannot start from within stream pipeline");
        }

        @Override
        public List<PacketData> end() {
            throw new IllegalStateException("Cannot end from within stream pipeline");
        }
    }

    private static final class AbstractPacketStreamImpl
    extends AbstractPacketStream {
        private final Supplier<PacketData> supplier;

        public AbstractPacketStreamImpl(Supplier<PacketData> supplier) {
            this.supplier = supplier;
        }

        @Override
        public void start() {
        }

        @Override
        protected void cleanup() {
        }

        @Override
        protected PacketData nextInput() {
            return this.supplier.get();
        }
    }
}

