/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.studio;

import com.replaymod.replaystudio.Studio;
import com.replaymod.replaystudio.filter.StreamFilter;
import com.replaymod.replaystudio.viaversion.ViaVersionPacketConverter;
import java.util.ServiceLoader;

public class ReplayStudio
implements Studio {
    private final ServiceLoader<StreamFilter> streamFilterServiceLoader = ServiceLoader.load(StreamFilter.class);

    @Override
    public String getName() {
        return "ReplayStudio";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public StreamFilter loadStreamFilter(String name) {
        for (StreamFilter filter : this.streamFilterServiceLoader) {
            if (!filter.getName().equalsIgnoreCase(name)) continue;
            try {
                return (StreamFilter)filter.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public boolean isCompatible(int fileVersion, int protocolVersion, int currentVersion) {
        return ViaVersionPacketConverter.isFileVersionSupported(fileVersion, protocolVersion, currentVersion);
    }

    @Override
    public int getCurrentFileFormatVersion() {
        return 14;
    }
}

