/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.viaversion;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.viaversion.ViaAPIBase;
import com.replaymod.replaystudio.lib.viaversion.api.Via;
import com.replaymod.replaystudio.lib.viaversion.api.connection.UserConnection;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import java.util.UUID;

class CustomViaAPI
extends ViaAPIBase<Void> {
    static final ThreadLocal<CustomViaAPI> INSTANCE = new ThreadLocal();
    private final int sourceVersion;
    private final UserConnection userConnection;

    CustomViaAPI(int sourceVersion, UserConnection userConnection) {
        this.sourceVersion = sourceVersion;
        this.userConnection = userConnection;
    }

    UserConnection user() {
        return this.userConnection;
    }

    @Override
    public int getPlayerVersion(Void aVoid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProtocolVersion getPlayerProtocolVersion(Void unused) {
        return ProtocolVersion.getProtocol(this.sourceVersion);
    }

    @Override
    public int getPlayerVersion(UUID uuid) {
        if (uuid.equals(this.userConnection.getProtocolInfo().getUuid())) {
            return this.sourceVersion;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInjected(UUID uuid) {
        return this.sourceVersion >= 107;
    }

    @Override
    public String getVersion() {
        return Via.getPlatform().getPluginVersion();
    }

    @Override
    public void sendRawPacket(Void aVoid, ByteBuf byteBuf) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendRawPacket(UUID uuid, ByteBuf byteBuf) throws IllegalArgumentException {
        if (uuid.equals(this.userConnection.getProtocolInfo().getUuid())) {
            this.userConnection.sendRawPacket(byteBuf);
            return;
        }
        throw new UnsupportedOperationException();
    }
}

