/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.viaversion;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.channel.ChannelFuture;
import com.github.steveice10.netty.channel.embedded.EmbeddedChannel;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetInput;
import com.replaymod.replaystudio.lib.viaversion.api.Via;
import com.replaymod.replaystudio.lib.viaversion.api.connection.ProtocolInfo;
import com.replaymod.replaystudio.lib.viaversion.api.connection.UserConnection;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.ProtocolPathEntry;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.ProtocolPipeline;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.Direction;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.PacketWrapper;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.lib.viaversion.connection.UserConnectionImpl;
import com.replaymod.replaystudio.lib.viaversion.exception.CancelException;
import com.replaymod.replaystudio.lib.viaversion.protocol.ProtocolPipelineImpl;
import com.replaymod.replaystudio.lib.viaversion.protocols.v1_20to1_20_2.storage.ConfigurationState;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import com.replaymod.replaystudio.viaversion.CustomViaAPI;
import com.replaymod.replaystudio.viaversion.CustomViaManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class ViaVersionPacketConverter {
    private final UserConnection user;
    private final CustomViaAPI viaAPI;
    private final ProtocolPipeline pipeline;
    private List<ByteBuf> out = new ArrayList<ByteBuf>();

    @Deprecated
    public static ViaVersionPacketConverter createForFileVersion(int input, int output) {
        return ViaVersionPacketConverter.createForFileVersion(input, 0, ReplayMetaData.PROTOCOL_FOR_FILE_FORMAT.get(output));
    }

    public static ViaVersionPacketConverter createForFileVersion(int fileVersion, int fileProtocol, int outputProtocol) {
        if (!ReplayMetaData.PROTOCOL_FOR_FILE_FORMAT.containsKey(fileVersion) && fileVersion < 10) {
            throw new IllegalArgumentException("Unknown file version");
        }
        return ViaVersionPacketConverter.createForProtocolVersion(fileVersion < 10 ? ReplayMetaData.PROTOCOL_FOR_FILE_FORMAT.get(fileVersion) : fileProtocol, outputProtocol);
    }

    public static ViaVersionPacketConverter createForProtocolVersion(int input, int output) {
        return new ViaVersionPacketConverter(input, output);
    }

    @Deprecated
    public static boolean isFileVersionSupported(int input, int output) {
        return ReplayMetaData.PROTOCOL_FOR_FILE_FORMAT.containsKey(input) && ReplayMetaData.PROTOCOL_FOR_FILE_FORMAT.containsKey(output) && ViaVersionPacketConverter.isProtocolVersionSupported(ReplayMetaData.PROTOCOL_FOR_FILE_FORMAT.get(input), ReplayMetaData.PROTOCOL_FOR_FILE_FORMAT.get(output));
    }

    public static boolean isFileVersionSupported(int fileVersion, int fileProtocol, int outputProtocol) {
        if (fileVersion < 10) {
            if (!ReplayMetaData.PROTOCOL_FOR_FILE_FORMAT.containsKey(fileVersion)) {
                return false;
            }
            fileProtocol = ReplayMetaData.PROTOCOL_FOR_FILE_FORMAT.get(fileVersion);
        }
        return ViaVersionPacketConverter.isProtocolVersionSupported(fileProtocol, outputProtocol);
    }

    public static boolean isProtocolVersionSupported(int input, int output) {
        if (input == output) {
            return true;
        }
        CustomViaManager.initialize();
        return Via.getManager().getProtocolManager().getProtocolPath(output, input) != null;
    }

    private ViaVersionPacketConverter(int inputProtocol, int outputProtocol) {
        CustomViaManager.initialize();
        List<ProtocolPathEntry> path = Via.getManager().getProtocolManager().getProtocolPath(outputProtocol, inputProtocol);
        if (path != null) {
            this.user = new DummyUserConnection();
            this.viaAPI = new CustomViaAPI(inputProtocol, this.user);
            this.pipeline = new ProtocolPipelineImpl(this.user);
            ProtocolInfo protocolInfo = this.user.getProtocolInfo();
            protocolInfo.setClientState(outputProtocol >= ProtocolVersion.v1_20_2.getVersion() ? State.CONFIGURATION : State.PLAY);
            protocolInfo.setServerState(inputProtocol >= ProtocolVersion.v1_20_2.getVersion() ? State.CONFIGURATION : State.PLAY);
            protocolInfo.setUsername("$Camera$");
            protocolInfo.setUuid(UUID.randomUUID());
            path.stream().map(ProtocolPathEntry::protocol).forEachOrdered(this.pipeline::add);
        } else {
            this.user = null;
            this.viaAPI = null;
            this.pipeline = null;
        }
    }

    public void loginAcknowledged() throws IOException {
        if (this.user == null) {
            return;
        }
        CustomViaAPI.INSTANCE.set(this.viaAPI);
        try {
            ConfigurationState configurationState = this.user.get(ConfigurationState.class);
            if (configurationState == null) {
                return;
            }
            configurationState.setBridgePhase(ConfigurationState.BridgePhase.CONFIGURATION);
            configurationState.sendQueuedPackets(this.user);
        }
        catch (Exception e) {
            throw new IOException("Exception during ViaVersion conversion:", e);
        }
        finally {
            CustomViaAPI.INSTANCE.remove();
        }
    }

    public void finishConfiguration() throws IOException {
        if (this.user == null) {
            return;
        }
        CustomViaAPI.INSTANCE.set(this.viaAPI);
        try {
            ConfigurationState configurationState = this.user.get(ConfigurationState.class);
            if (configurationState == null) {
                return;
            }
            configurationState.setBridgePhase(ConfigurationState.BridgePhase.NONE);
            configurationState.sendQueuedPackets(this.user);
            configurationState.clear();
        }
        catch (Exception e) {
            throw new IOException("Exception during ViaVersion conversion:", e);
        }
        finally {
            CustomViaAPI.INSTANCE.remove();
        }
    }

    @Deprecated
    public List<ByteBuf> convertPacket(ByteBuf buf) throws IOException {
        return this.convertPacket(buf, State.PLAY);
    }

    /*
     * Loose catch block
     */
    public List<ByteBuf> convertPacket(ByteBuf buf, State state) throws IOException {
        if (this.user == null) {
            buf.retain();
            return Collections.singletonList(buf);
        }
        CustomViaAPI.INSTANCE.set(this.viaAPI);
        try {
            int packetId = new ByteBufNetInput(buf).readVarInt();
            PacketWrapper packetWrapper = PacketWrapper.create(packetId, buf, this.user);
            try {
                this.pipeline.transform(Direction.CLIENTBOUND, state, packetWrapper);
            }
            catch (CancelException e) {
                if (!this.out.isEmpty()) {
                    List<ByteBuf> list = this.popOut();
                    CustomViaAPI.INSTANCE.remove();
                    return list;
                }
                List<ByteBuf> list = Collections.emptyList();
                CustomViaAPI.INSTANCE.remove();
                return list;
            }
            ByteBuf result = buf.alloc().buffer();
            packetWrapper.writeToBuffer(result);
            if (!this.out.isEmpty()) {
                this.out.add(result);
                List<ByteBuf> list = this.popOut();
                return list;
            }
            List<ByteBuf> list = Collections.singletonList(result);
            return list;
            {
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException("Exception during ViaVersion conversion:", e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            CustomViaAPI.INSTANCE.remove();
        }
    }

    private List<ByteBuf> popOut() {
        try {
            List<ByteBuf> list = this.out;
            return list;
        }
        finally {
            this.out = new ArrayList<ByteBuf>();
        }
    }

    private final class DummyUserConnection
    extends UserConnectionImpl {
        DummyUserConnection() {
            super(new EmbeddedChannel());
        }

        @Override
        public void sendRawPacket(ByteBuf packet) {
            ViaVersionPacketConverter.this.out.add(packet);
        }

        @Override
        public void scheduleSendRawPacket(ByteBuf packet) {
            ViaVersionPacketConverter.this.out.add(packet);
        }

        @Override
        public ChannelFuture sendRawPacketFuture(ByteBuf packet) {
            throw new UnsupportedOperationException();
        }
    }
}

