/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.simplepathing;

import com.replaymod.core.SettingsRegistry;
import com.replaymod.simplepathing.InterpolatorType;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class Setting<T>
extends SettingsRegistry.SettingKeys<T> {
    public static final Setting<Boolean> PATH_PREVIEW = Setting.make("pathpreview", "pathpreview", true);
    public static final Setting<Boolean> AUTO_SYNC = Setting.make("autosync", null, true);
    public static final Setting<Integer> TIMELINE_LENGTH = Setting.make("timelineLength", null, 1800);
    public static final SettingsRegistry.MultipleChoiceSettingKeys<String> DEFAULT_INTERPOLATION;

    private static <T> Setting<T> make(String key, String displayName, T defaultValue) {
        return new Setting<T>(key, displayName, defaultValue);
    }

    public Setting(String key, String displayString, T defaultValue) {
        super("simplepathing", key, displayString == null ? null : "replaymod.gui.settings." + displayString, defaultValue);
    }

    static {
        String format = "replaymod.gui.editkeyframe.interpolator.%s.name";
        DEFAULT_INTERPOLATION = new SettingsRegistry.MultipleChoiceSettingKeys<String>("simplepathing", "interpolator", "replaymod.gui.settings.interpolator", String.format(format, InterpolatorType.fromString("invalid returns default").getLocalizationKey()));
        DEFAULT_INTERPOLATION.setChoices(Arrays.stream(InterpolatorType.values()).filter(i -> i != InterpolatorType.DEFAULT).map(i -> String.format(format, i.getLocalizationKey())).collect(Collectors.toList()));
    }
}

