/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.simplepathing.preview;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.events.PostRenderWorldCallback;
import com.replaymod.core.versions.MCVer;
import com.replaymod.pathing.properties.CameraProperties;
import com.replaymod.pathing.properties.SpectatorProperty;
import com.replaymod.pathing.properties.TimestampProperty;
import com.replaymod.replay.ReplayHandler;
import com.replaymod.replaystudio.pathing.path.Keyframe;
import com.replaymod.replaystudio.pathing.path.PathSegment;
import com.replaymod.replaystudio.util.Location;
import com.replaymod.simplepathing.ReplayModSimplePathing;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.utils.lwjgl.vector.Vector3f;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.lwjgl.opengl.GL11;

public class PathPreviewRenderer
extends EventRegistrations {
    private static final ResourceLocation CAMERA_HEAD = ResourceLocation.fromNamespaceAndPath((String)"replaymod", (String)"camera_head.png");
    private static final Minecraft mc = MCVer.getMinecraft();
    private static final int SLOW_PATH_COLOR = 0xFFCCCC;
    private static final int FAST_PATH_COLOR = 0x660000;
    private static final double FASTEST_PATH_SPEED = 0.01;
    private final ReplayModSimplePathing mod;
    private final ReplayHandler replayHandler;

    public PathPreviewRenderer(ReplayModSimplePathing mod, ReplayHandler replayHandler) {
        this.on(PostRenderWorldCallback.EVENT, this::renderCameraPath);
        this.mod = mod;
        this.replayHandler = replayHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void renderCameraPath(PoseStack matrixStack) {
        if (!this.replayHandler.getReplaySender().isAsyncMode() || PathPreviewRenderer.mc.options.hideGui) {
            return;
        }
        view = PathPreviewRenderer.mc.getCameraEntity();
        if (view == null) {
            return;
        }
        guiPathing = this.mod.getGuiPathing();
        if (guiPathing == null) {
            return;
        }
        entityTracker = guiPathing.getEntityTracker();
        timeline = this.mod.getCurrentTimeline();
        if (timeline == null) {
            return;
        }
        path = timeline.getPositionPath();
        if (path.getKeyframes().isEmpty()) {
            return;
        }
        timePath = timeline.getTimePath();
        path.update();
        renderDistance = (Integer)PathPreviewRenderer.mc.options.renderDistance().get() * 16;
        renderDistanceSquared = renderDistance * renderDistance;
        viewPos = new Vector3f((float)view.getX(), (float)view.getY(), (float)view.getZ());
        MCVer.pushMatrix();
        try {
            RenderSystem.getModelViewStack().mul((Matrix4fc)matrixStack.last().pose());
            RenderSystem.applyModelViewMatrix();
            for (PathSegment segment : path.getSegments()) {
                interpolator = segment.getInterpolator();
                start = segment.getStartKeyframe();
                end = segment.getEndKeyframe();
                diff = (int)(end.getTime() - start.getTime());
                spectator = interpolator.getKeyframeProperties().contains(SpectatorProperty.PROPERTY);
                if (spectator && entityTracker == null) continue;
                steps = spectator != false ? Math.max(diff / 50L, 10L) : 100L;
                prevPos = null;
                i = 0;
                while ((long)i <= steps) {
                    block20: {
                        block19: {
                            time = start.getTime() + diff * (long)i / steps;
                            if (!spectator) break block19;
                            entityId = path.getValue(SpectatorProperty.PROPERTY, time);
                            replayTime = timePath.getValue(TimestampProperty.PROPERTY, time);
                            if (!entityId.isPresent() || !replayTime.isPresent() || (loc = entityTracker.getEntityPositionAtTimestamp(entityId.get(), replayTime.get().intValue())) == null) ** GOTO lbl-1000
                            pos = this.loc2Vec(loc);
                            if (prevPos != null) {
                                this.drawConnection(viewPos, prevPos, pos, 65535, renderDistanceSquared);
                            }
                            prevPos = pos;
                            break block20;
                        }
                        optPos = path.getValue(CameraProperties.POSITION, time).map((Function<Triple, Vector3f>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, tripleD2Vec(org.apache.commons.lang3.tuple.Triple<java.lang.Double, java.lang.Double, java.lang.Double> ), (Lorg/apache/commons/lang3/tuple/Triple;)Lde/johni0702/minecraft/gui/utils/lwjgl/vector/Vector3f;)((PathPreviewRenderer)this));
                        if (optPos.isPresent()) {
                            pos = optPos.get();
                            if (prevPos != null) {
                                distance = Math.sqrt(PathPreviewRenderer.distanceSquared(prevPos, pos));
                                speed = Math.min(distance / (double)(diff / steps), 0.01);
                                speedFraction = speed / 0.01;
                                color = PathPreviewRenderer.interpolateColor(0xFFCCCC, 0x660000, speedFraction);
                                this.drawConnection(viewPos, prevPos, pos, color << 8 | 255, renderDistanceSquared);
                            }
                            prevPos = pos;
                        } else lbl-1000:
                        // 2 sources

                        {
                            prevPos = null;
                        }
                    }
                    ++i;
                }
            }
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)774, (int)768);
            GL11.glDisable((int)2929);
            path.getKeyframes().stream().map((Function<Keyframe, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$renderCameraPath$0(com.replaymod.replaystudio.pathing.path.Keyframe ), (Lcom/replaymod/replaystudio/pathing/path/Keyframe;)Lorg/apache/commons/lang3/tuple/Pair;)((PathPreviewRenderer)this)).filter((Predicate<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$renderCameraPath$1(org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)Z)()).map((Function<Pair, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$renderCameraPath$2(org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)Lorg/apache/commons/lang3/tuple/Pair;)()).filter((Predicate<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$renderCameraPath$3(de.johni0702.minecraft.gui.utils.lwjgl.vector.Vector3f int org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)Z)((Vector3f)viewPos, (int)renderDistanceSquared)).sorted(new KeyframeComparator(this, viewPos)).forEachOrdered((Consumer<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$renderCameraPath$4(de.johni0702.minecraft.gui.utils.lwjgl.vector.Vector3f org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)V)((PathPreviewRenderer)this, (Vector3f)viewPos));
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)2929);
            time = guiPathing.timeline.getCursorPosition();
            entityId = path.getValue(SpectatorProperty.PROPERTY, time);
            if (entityId.isPresent()) {
                if (entityTracker != null && (replayTime = timePath.getValue(TimestampProperty.PROPERTY, time)).isPresent() && (loc = entityTracker.getEntityPositionAtTimestamp(entityId.get(), replayTime.get().intValue())) != null) {
                    this.drawCamera(viewPos, this.loc2Vec(loc), new Vector3f(loc.getYaw(), loc.getPitch(), 0.0f));
                }
            } else {
                cameraPos = path.getValue(CameraProperties.POSITION, time).map((Function<Triple, Vector3f>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, tripleD2Vec(org.apache.commons.lang3.tuple.Triple<java.lang.Double, java.lang.Double, java.lang.Double> ), (Lorg/apache/commons/lang3/tuple/Triple;)Lde/johni0702/minecraft/gui/utils/lwjgl/vector/Vector3f;)((PathPreviewRenderer)this));
                cameraRot = path.getValue(CameraProperties.ROTATION, time).map((Function<Triple, Vector3f>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, tripleF2Vec(org.apache.commons.lang3.tuple.Triple<java.lang.Float, java.lang.Float, java.lang.Float> ), (Lorg/apache/commons/lang3/tuple/Triple;)Lde/johni0702/minecraft/gui/utils/lwjgl/vector/Vector3f;)((PathPreviewRenderer)this));
                if (cameraPos.isPresent() && cameraRot.isPresent()) {
                    this.drawCamera(viewPos, cameraPos.get(), cameraRot.get());
                }
            }
        }
        finally {
            MCVer.popMatrix();
            GL11.glDisable((int)3042);
        }
    }

    private Vector3f loc2Vec(Location loc) {
        return new Vector3f((float)loc.getX(), (float)loc.getY(), (float)loc.getZ());
    }

    private Vector3f tripleD2Vec(Triple<Double, Double, Double> loc) {
        return new Vector3f(((Double)loc.getLeft()).floatValue(), ((Double)loc.getMiddle()).floatValue(), ((Double)loc.getRight()).floatValue());
    }

    private Vector3f tripleF2Vec(Triple<Float, Float, Float> loc) {
        return new Vector3f(((Float)loc.getLeft()).floatValue(), ((Float)loc.getMiddle()).floatValue(), ((Float)loc.getRight()).floatValue());
    }

    private static int interpolateColor(int c1, int c2, double weight) {
        return PathPreviewRenderer.interpolateColorComponent(c1 >> 16 & 0xFF, c2 >> 16 & 0xFF, weight) << 16 | PathPreviewRenderer.interpolateColorComponent(c1 >> 8 & 0xFF, c2 >> 8 & 0xFF, weight) << 8 | PathPreviewRenderer.interpolateColorComponent(c1 & 0xFF, c2 & 0xFF, weight);
    }

    private static int interpolateColorComponent(int c1, int c2, double weight) {
        return (int)((double)c1 + (1.0 - Math.pow(Math.E, -4.0 * weight)) * (double)(c2 - c1)) & 0xFF;
    }

    private static double distanceSquared(Vector3f p1, Vector3f p2) {
        return Vector3f.sub((Vector3f)p1, (Vector3f)p2, null).lengthSquared();
    }

    private void drawConnection(Vector3f view, Vector3f pos1, Vector3f pos2, int color, int renderDistanceSquared) {
        if (PathPreviewRenderer.distanceSquared(view, pos1) > (double)renderDistanceSquared) {
            return;
        }
        if (PathPreviewRenderer.distanceSquared(view, pos2) > (double)renderDistanceSquared) {
            return;
        }
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        MCVer.emitLine(new PoseStack(), buffer, Vector3f.sub((Vector3f)pos1, (Vector3f)view, null), Vector3f.sub((Vector3f)pos2, (Vector3f)view, null), color);
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)3.0f);
        try (MeshData builtBuffer = buffer.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)builtBuffer);
        }
        RenderSystem.enableCull();
    }

    private void drawPoint(Vector3f view, Vector3f pos, Keyframe keyframe) {
        MCVer.bindTexture(ReplayMod.TEXTURE);
        float posX = 0.3125f;
        float posY = 0.0f;
        float size = 0.0390625f;
        if (this.mod.isSelected(keyframe)) {
            posY += size;
        }
        if (keyframe.getValue(SpectatorProperty.PROPERTY).isPresent()) {
            posX += size;
        }
        float minX = -0.5f;
        float minY = -0.5f;
        float maxX = 0.5f;
        float maxY = 0.5f;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(minX, minY, 0.0f).setUv(posX + size, posY + size);
        buffer.addVertex(minX, maxY, 0.0f).setUv(posX + size, posY);
        buffer.addVertex(maxX, maxY, 0.0f).setUv(posX, posY);
        buffer.addVertex(maxX, minY, 0.0f).setUv(posX, posY + size);
        MCVer.pushMatrix();
        Vector3f t = Vector3f.sub((Vector3f)pos, (Vector3f)view, null);
        RenderSystem.getModelViewStack().translate(t.x, t.y, t.z);
        RenderSystem.getModelViewStack().rotate((Quaternionfc)MCVer.quaternion(-PathPreviewRenderer.mc.getEntityRenderDispatcher().camera.getYRot(), new org.joml.Vector3f(0.0f, 1.0f, 0.0f)));
        RenderSystem.getModelViewStack().rotate((Quaternionfc)MCVer.quaternion(PathPreviewRenderer.mc.getEntityRenderDispatcher().camera.getXRot(), new org.joml.Vector3f(1.0f, 0.0f, 0.0f)));
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        try (MeshData builtBuffer = buffer.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)builtBuffer);
        }
        MCVer.popMatrix();
    }

    private void drawCamera(Vector3f view, Vector3f pos, Vector3f rot) {
        MCVer.bindTexture(CAMERA_HEAD);
        MCVer.pushMatrix();
        Vector3f t = Vector3f.sub((Vector3f)pos, (Vector3f)view, null);
        RenderSystem.getModelViewStack().translate(t.x, t.y, t.z);
        RenderSystem.getModelViewStack().rotate((Quaternionfc)MCVer.quaternion(-rot.x, new org.joml.Vector3f(0.0f, 1.0f, 0.0f)));
        RenderSystem.getModelViewStack().rotate((Quaternionfc)MCVer.quaternion(rot.y, new org.joml.Vector3f(1.0f, 0.0f, 0.0f)));
        RenderSystem.getModelViewStack().rotate((Quaternionfc)MCVer.quaternion(rot.z, new org.joml.Vector3f(0.0f, 0.0f, 1.0f)));
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        MCVer.emitLine(new PoseStack(), buffer, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 2.0f), 0xFF00AA);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        try (MeshData builtBuffer = buffer.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)builtBuffer);
        }
        float cubeSize = 0.5f;
        float r = -cubeSize / 2.0f;
        buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(r, r + cubeSize, r).setUv(0.375f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r + cubeSize, r).setUv(0.5f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r, r).setUv(0.5f, 0.25f).setColor(255, 255, 255, 200);
        buffer.addVertex(r, r, r).setUv(0.375f, 0.25f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r, r + cubeSize).setUv(0.25f, 0.25f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r + cubeSize, r + cubeSize).setUv(0.25f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r, r + cubeSize, r + cubeSize).setUv(0.125f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r, r, r + cubeSize).setUv(0.125f, 0.25f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r + cubeSize, r).setUv(0.0f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r + cubeSize, r + cubeSize).setUv(0.125f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r, r + cubeSize).setUv(0.125f, 0.25f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r, r).setUv(0.0f, 0.25f).setColor(255, 255, 255, 200);
        buffer.addVertex(r, r + cubeSize, r + cubeSize).setUv(0.25f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r, r + cubeSize, r).setUv(0.375f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r, r, r).setUv(0.375f, 0.25f).setColor(255, 255, 255, 200);
        buffer.addVertex(r, r, r + cubeSize).setUv(0.25f, 0.25f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r, r).setUv(0.375f, 0.0f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r, r + cubeSize).setUv(0.375f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r, r, r + cubeSize).setUv(0.25f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r, r, r).setUv(0.25f, 0.0f).setColor(255, 255, 255, 200);
        buffer.addVertex(r, r + cubeSize, r).setUv(0.125f, 0.0f).setColor(255, 255, 255, 200);
        buffer.addVertex(r, r + cubeSize, r + cubeSize).setUv(0.125f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r + cubeSize, r + cubeSize).setUv(0.25f, 0.125f).setColor(255, 255, 255, 200);
        buffer.addVertex(r + cubeSize, r + cubeSize, r).setUv(0.25f, 0.0f).setColor(255, 255, 255, 200);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        try (MeshData builtBuffer = buffer.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)builtBuffer);
        }
        MCVer.popMatrix();
    }

    private /* synthetic */ void lambda$renderCameraPath$4(Vector3f viewPos, Pair p) {
        this.drawPoint(viewPos, (Vector3f)p.getRight(), (Keyframe)p.getLeft());
    }

    private static /* synthetic */ boolean lambda$renderCameraPath$3(Vector3f viewPos, int renderDistanceSquared, Pair p) {
        return PathPreviewRenderer.distanceSquared((Vector3f)p.getRight(), viewPos) < (double)renderDistanceSquared;
    }

    private static /* synthetic */ Pair lambda$renderCameraPath$2(Pair p) {
        return Pair.of((Object)((Keyframe)p.getLeft()), (Object)((Vector3f)((Optional)p.getRight()).get()));
    }

    private static /* synthetic */ boolean lambda$renderCameraPath$1(Pair p) {
        return ((Optional)p.getRight()).isPresent();
    }

    private /* synthetic */ Pair lambda$renderCameraPath$0(Keyframe k) {
        return Pair.of((Object)k, k.getValue(CameraProperties.POSITION).map(this::tripleD2Vec));
    }

    private class KeyframeComparator
    implements Comparator<Pair<Keyframe, Vector3f>> {
        private final Vector3f viewPos;

        public KeyframeComparator(PathPreviewRenderer pathPreviewRenderer, Vector3f viewPos) {
            this.viewPos = viewPos;
        }

        @Override
        public int compare(Pair<Keyframe, Vector3f> o1, Pair<Keyframe, Vector3f> o2) {
            return -Double.compare(PathPreviewRenderer.distanceSquared((Vector3f)o1.getRight(), this.viewPos), PathPreviewRenderer.distanceSquared((Vector3f)o2.getRight(), this.viewPos));
        }
    }
}

