/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.utils.NonNull;
import de.johni0702.minecraft.gui.utils.lwjgl.Color;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.utils.lwjgl.WritableDimension;
import de.johni0702.minecraft.gui.versions.MCVer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class MinecraftGuiRenderer
implements GuiRenderer {
    private final Minecraft mc = MCVer.getMinecraft();
    private final GuiGraphics context;
    private final PoseStack matrixStack;
    @NonNull
    private final int scaledWidth = MCVer.newScaledResolution(this.mc).getGuiScaledWidth();
    private final int scaledHeight = MCVer.newScaledResolution(this.mc).getGuiScaledHeight();
    private final double scaleFactor = MCVer.newScaledResolution(this.mc).getGuiScale();

    public MinecraftGuiRenderer(GuiGraphics context) {
        this.context = context;
        this.matrixStack = context.pose();
    }

    @Override
    public ReadablePoint getOpenGlOffset() {
        return new Point(0, 0);
    }

    @Override
    public GuiGraphics getContext() {
        return this.context;
    }

    @Override
    public PoseStack getMatrixStack() {
        return this.matrixStack;
    }

    @Override
    public ReadableDimension getSize() {
        return new ReadableDimension(){

            public int getWidth() {
                return MinecraftGuiRenderer.this.scaledWidth;
            }

            public int getHeight() {
                return MinecraftGuiRenderer.this.scaledHeight;
            }

            public void getSize(WritableDimension dest) {
                dest.setSize(this.getWidth(), this.getHeight());
            }
        };
    }

    @Override
    public void setDrawingArea(int x, int y, int width, int height) {
        y = this.scaledHeight - y - height;
        int f = (int)this.scaleFactor;
        MCVer.setScissorBounds(x * f, y * f, width * f, height * f);
    }

    @Override
    public void bindTexture(ResourceLocation location) {
        MCVer.bindTexture(location);
    }

    @Override
    public void bindTexture(int glId) {
        RenderSystem.setShaderTexture((int)0, (int)glId);
    }

    @Override
    public void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        this.drawTexturedRect(x, y, u, v, width, height, width, height, 256, 256);
    }

    @Override
    public void drawTexturedRect(int x, int y, int u, int v, int width, int height, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.color(1.0f, 1.0f, 1.0f);
        this.drawTexturedRect(x, x + width, y, y + height, (float)u / (float)textureWidth, (float)(u + uWidth) / (float)textureWidth, (float)v / (float)textureHeight, (float)(v + vHeight) / (float)textureHeight);
    }

    private void drawTexturedRect(int x1, int x2, int y1, int y2, float u1, float u2, float v1, float v2) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = this.matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, (float)x1, (float)y1, 0.0f).setUv(u1, v1);
        bufferBuilder.addVertex(matrix, (float)x1, (float)y2, 0.0f).setUv(u1, v2);
        bufferBuilder.addVertex(matrix, (float)x2, (float)y2, 0.0f).setUv(u2, v2);
        bufferBuilder.addVertex(matrix, (float)x2, (float)y1, 0.0f).setUv(u2, v1);
        try (MeshData builtBuffer = bufferBuilder.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)builtBuffer);
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height, int color) {
        this.context.fill(x, y, x + width, y + height, color);
        this.color(1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
    }

    @Override
    public void drawRect(int x, int y, int width, int height, ReadableColor color) {
        this.drawRect(x, y, width, height, this.color(color));
    }

    @Override
    public void drawRect(int x, int y, int width, int height, int topLeftColor, int topRightColor, int bottomLeftColor, int bottomRightColor) {
        this.drawRect(x, y, width, height, this.color(topLeftColor), this.color(topRightColor), this.color(bottomLeftColor), this.color(bottomRightColor));
    }

    @Override
    public void drawRect(int x, int y, int width, int height, ReadableColor tl, ReadableColor tr, ReadableColor bl, ReadableColor br) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        MCVer.drawRect(x, y, width, height, tl, tr, bl, br);
    }

    @Override
    public int drawString(int x, int y, int color, String text) {
        return this.drawString(x, y, color, text, false);
    }

    @Override
    public int drawString(int x, int y, ReadableColor color, String text) {
        return this.drawString(x, y, this.color(color), text);
    }

    @Override
    public int drawCenteredString(int x, int y, int color, String text) {
        return this.drawCenteredString(x, y, color, text, false);
    }

    @Override
    public int drawCenteredString(int x, int y, ReadableColor color, String text) {
        return this.drawCenteredString(x, y, this.color(color), text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drawString(int x, int y, int color, String text, boolean shadow) {
        Font fontRenderer = MCVer.getFontRenderer();
        try {
            int n = this.context.drawString(fontRenderer, text, x, y, color, shadow);
            return n;
        }
        finally {
            this.color(1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public int drawString(int x, int y, ReadableColor color, String text, boolean shadow) {
        return this.drawString(x, y, this.color(color), text, shadow);
    }

    @Override
    public int drawCenteredString(int x, int y, int color, String text, boolean shadow) {
        Font fontRenderer = MCVer.getFontRenderer();
        return this.drawString(x -= fontRenderer.width(text) / 2, y, color, text, shadow);
    }

    @Override
    public int drawCenteredString(int x, int y, ReadableColor color, String text, boolean shadow) {
        return this.drawCenteredString(x, y, this.color(color), text, shadow);
    }

    private int color(ReadableColor color) {
        return color.getAlpha() << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
    }

    private ReadableColor color(int color) {
        return new Color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
    }

    private void color(float r, float g, float b) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
    }

    @Override
    public void invertColors(int right, int bottom, int left, int top) {
        if (left >= right || top >= bottom) {
            return;
        }
        this.color(0.0f, 0.0f, 1.0f);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        MCVer.drawRect(right, bottom, left, top);
        RenderSystem.disableColorLogicOp();
        this.color(1.0f, 1.0f, 1.0f);
    }
}

