/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.container;

import com.google.common.base.Preconditions;
import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.OffsetGuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractComposedGuiElement;
import de.johni0702.minecraft.gui.element.ComposedGuiElement;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.layout.Layout;
import de.johni0702.minecraft.gui.layout.LayoutData;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.versions.MCVer;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractGuiContainer<T extends AbstractGuiContainer<T>>
extends AbstractComposedGuiElement<T>
implements GuiContainer<T> {
    private static final Layout DEFAULT_LAYOUT = new HorizontalLayout();
    private Map<GuiElement, LayoutData> elements = new LinkedHashMap<GuiElement, LayoutData>();
    private Map<GuiElement, Pair<ReadablePoint, ReadableDimension>> layedOutElements;
    private Layout layout = DEFAULT_LAYOUT;
    private ReadableColor backgroundColor;

    public AbstractGuiContainer() {
    }

    public AbstractGuiContainer(GuiContainer container) {
        super(container);
    }

    @Override
    public T setLayout(Layout layout) {
        this.layout = layout;
        return (T)((AbstractGuiContainer)this.getThis());
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public void convertFor(GuiElement element, Point point) {
        this.convertFor(element, point, element.getLayer());
    }

    @Override
    public void convertFor(GuiElement element, Point point, int relativeLayer) {
        if (this.layedOutElements == null || !this.layedOutElements.containsKey(element)) {
            this.layout(null, new RenderInfo(0.0f, 0, 0, relativeLayer));
        }
        Preconditions.checkState((this.layedOutElements != null ? 1 : 0) != 0, (Object)"Cannot convert position unless rendered at least once.");
        Pair<ReadablePoint, ReadableDimension> pair = this.layedOutElements.get(element);
        Preconditions.checkState((pair != null ? 1 : 0) != 0, (Object)("Element " + String.valueOf(element) + " not part of " + String.valueOf(this)));
        ReadablePoint pos = (ReadablePoint)pair.getKey();
        if (this.getContainer() != null) {
            this.getContainer().convertFor(this, point, relativeLayer + this.getLayer());
        }
        point.translate(-pos.getX(), -pos.getY());
    }

    @Override
    public Collection<GuiElement> getChildren() {
        return Collections.unmodifiableCollection(this.elements.keySet());
    }

    @Override
    public Map<GuiElement, LayoutData> getElements() {
        return Collections.unmodifiableMap(this.elements);
    }

    @Override
    public T addElements(LayoutData layoutData, GuiElement ... elements) {
        if (layoutData == null) {
            layoutData = LayoutData.NONE;
        }
        for (GuiElement element : elements) {
            this.elements.put(element, layoutData);
            element.setContainer(this);
        }
        return (T)((AbstractGuiContainer)this.getThis());
    }

    @Override
    public T removeElement(GuiElement element) {
        if (this.elements.remove(element) != null) {
            element.setContainer(null);
            if (this.layedOutElements != null) {
                this.layedOutElements.remove(element);
            }
        }
        return (T)((AbstractGuiContainer)this.getThis());
    }

    @Override
    public void layout(ReadableDimension size, RenderInfo renderInfo) {
        super.layout(size, renderInfo);
        if (size == null) {
            return;
        }
        try {
            this.layedOutElements = this.layout.layOut(this, size);
        }
        catch (Exception ex) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)ex, (String)"Gui Layout");
            renderInfo.addTo(crashReport);
            CrashReportCategory category = crashReport.addCategory("Gui container details");
            MCVer.addDetail(category, "Container", this::toString);
            MCVer.addDetail(category, "Layout", (Callable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Layout)this.layout));
            throw new ReportedException(crashReport);
        }
        for (Map.Entry<GuiElement, Pair<ReadablePoint, ReadableDimension>> e : this.layedOutElements.entrySet()) {
            GuiElement element = e.getKey();
            if (element instanceof ComposedGuiElement ? ((ComposedGuiElement)element).getMaxLayer() < renderInfo.layer : element.getLayer() != renderInfo.layer) continue;
            ReadablePoint ePosition = (ReadablePoint)e.getValue().getLeft();
            ReadableDimension eSize = (ReadableDimension)e.getValue().getRight();
            element.layout(eSize, renderInfo.offsetMouse(ePosition.getX(), ePosition.getY()).layer(renderInfo.getLayer() - element.getLayer()));
        }
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        super.draw(renderer, size, renderInfo);
        if (this.backgroundColor != null && renderInfo.getLayer() == 0) {
            renderer.drawRect(0, 0, size.getWidth(), size.getHeight(), this.backgroundColor);
        }
        for (Map.Entry<GuiElement, Pair<ReadablePoint, ReadableDimension>> e : this.layedOutElements.entrySet()) {
            boolean strict;
            GuiElement element = e.getKey();
            if (element instanceof ComposedGuiElement) {
                if (((ComposedGuiElement)element).getMaxLayer() < renderInfo.layer) continue;
                strict = renderInfo.layer == 0;
            } else {
                if (element.getLayer() != renderInfo.layer) continue;
                strict = true;
            }
            ReadablePoint ePosition = (ReadablePoint)e.getValue().getLeft();
            ReadableDimension eSize = (ReadableDimension)e.getValue().getRight();
            try {
                OffsetGuiRenderer eRenderer = new OffsetGuiRenderer(renderer, ePosition, eSize, strict);
                eRenderer.startUsing();
                e.getKey().draw(eRenderer, eSize, renderInfo.offsetMouse(ePosition.getX(), ePosition.getY()).layer(renderInfo.getLayer() - e.getKey().getLayer()));
                eRenderer.stopUsing();
            }
            catch (Exception ex) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)ex, (String)"Rendering Gui");
                renderInfo.addTo(crashReport);
                CrashReportCategory category = crashReport.addCategory("Gui container details");
                MCVer.addDetail(category, "Container", this::toString);
                MCVer.addDetail(category, "Width", () -> "" + size.getWidth());
                MCVer.addDetail(category, "Height", () -> "" + size.getHeight());
                MCVer.addDetail(category, "Layout", (Callable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Layout)this.layout));
                category = crashReport.addCategory("Gui element details");
                MCVer.addDetail(category, "Element", () -> ((GuiElement)e.getKey()).toString());
                MCVer.addDetail(category, "Position", () -> ((ReadablePoint)ePosition).toString());
                MCVer.addDetail(category, "Size", () -> ((ReadableDimension)eSize).toString());
                if (e.getKey() instanceof GuiContainer) {
                    MCVer.addDetail(category, "Layout", () -> ((GuiContainer)e.getKey()).getLayout().toString());
                }
                throw new ReportedException(crashReport);
            }
        }
    }

    @Override
    public ReadableDimension calcMinSize() {
        return this.layout.calcMinSize(this);
    }

    @Override
    public T sortElements() {
        this.sortElements((Comparator)new Comparator<GuiElement>(this){

            @Override
            public int compare(GuiElement o1, GuiElement o2) {
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)((Object)o1)).compareTo(o2);
                }
                return o1.hashCode() - o2.hashCode();
            }
        });
        return (T)((AbstractGuiContainer)this.getThis());
    }

    @Override
    public T sortElements(Comparator<GuiElement> comparator) {
        this.elements = this.elements.entrySet().stream().sorted(Map.Entry.comparingByKey(comparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedHashMap::new));
        return (T)((AbstractGuiContainer)this.getThis());
    }

    @Override
    public ReadableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public T setBackgroundColor(ReadableColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return (T)((AbstractGuiContainer)this.getThis());
    }
}

