/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.container;

import com.mojang.blaze3d.platform.Window;
import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.MinecraftGuiRenderer;
import de.johni0702.minecraft.gui.OffsetGuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.AbstractGuiContainer;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.function.Closeable;
import de.johni0702.minecraft.gui.function.Draggable;
import de.johni0702.minecraft.gui.function.Loadable;
import de.johni0702.minecraft.gui.function.Scrollable;
import de.johni0702.minecraft.gui.function.Tickable;
import de.johni0702.minecraft.gui.function.Typeable;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.utils.MouseUtils;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.versions.MCVer;
import de.johni0702.minecraft.gui.versions.ScreenExt;
import de.johni0702.minecraft.gui.versions.callbacks.PreTickCallback;
import de.johni0702.minecraft.gui.versions.callbacks.RenderHudCallback;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.Callable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public abstract class AbstractGuiOverlay<T extends AbstractGuiOverlay<T>>
extends AbstractGuiContainer<T> {
    private final UserInputGuiScreen userInputGuiScreen = new UserInputGuiScreen();
    private final EventHandler eventHandler = new EventHandler();
    private boolean visible;
    private Dimension screenSize;
    private boolean mouseVisible;
    private boolean closeable = true;

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            if (visible) {
                this.invokeAll(Loadable.class, Loadable::load);
                this.eventHandler.register();
            } else {
                this.invokeAll(Closeable.class, Closeable::close);
                this.eventHandler.unregister();
            }
            this.updateUserInputGui();
        }
        this.visible = visible;
    }

    public boolean isMouseVisible() {
        return this.mouseVisible;
    }

    public void setMouseVisible(boolean mouseVisible) {
        this.mouseVisible = mouseVisible;
        this.updateUserInputGui();
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    public boolean isAllowUserInput() {
        return ((ScreenExt)((Object)this.userInputGuiScreen)).doesPassEvents();
    }

    public void setAllowUserInput(boolean allowUserInput) {
        ((ScreenExt)((Object)this.userInputGuiScreen)).setPassEvents(allowUserInput);
    }

    private void updateUserInputGui() {
        Minecraft mc = this.getMinecraft();
        if (this.visible) {
            if (this.mouseVisible) {
                if (mc.screen == null) {
                    mc.setScreen((Screen)this.userInputGuiScreen);
                }
            } else if (mc.screen == this.userInputGuiScreen) {
                mc.setScreen(null);
            }
        }
    }

    @Override
    public void layout(ReadableDimension size, RenderInfo renderInfo) {
        GuiElement tooltip;
        if (size == null) {
            size = this.screenSize;
        }
        super.layout(size, renderInfo);
        if (this.mouseVisible && renderInfo.layer == this.getMaxLayer() && (tooltip = this.forEach(GuiElement.class, e -> e.getTooltip(renderInfo))) != null) {
            tooltip.layout(tooltip.getMinSize(), renderInfo);
        }
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        GuiElement tooltip;
        super.draw(renderer, size, renderInfo);
        if (this.mouseVisible && renderInfo.layer == this.getMaxLayer() && (tooltip = this.forEach(GuiElement.class, e -> e.getTooltip(renderInfo))) != null) {
            ReadableDimension tooltipSize = tooltip.getMinSize();
            int x = renderInfo.mouseX + 8 + tooltipSize.getWidth() < this.screenSize.getWidth() ? renderInfo.mouseX + 8 : this.screenSize.getWidth() - tooltipSize.getWidth() - 1;
            int y = renderInfo.mouseY + 8 + tooltipSize.getHeight() < this.screenSize.getHeight() ? renderInfo.mouseY + 8 : this.screenSize.getHeight() - tooltipSize.getHeight() - 1;
            Point position = new Point(x, y);
            try {
                OffsetGuiRenderer eRenderer = new OffsetGuiRenderer(renderer, (ReadablePoint)position, tooltipSize);
                tooltip.draw(eRenderer, tooltipSize, renderInfo);
            }
            catch (Exception ex) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)ex, (String)"Rendering Gui Tooltip");
                renderInfo.addTo(crashReport);
                CrashReportCategory category = crashReport.addCategory("Gui container details");
                MCVer.addDetail(category, "Container", this::toString);
                MCVer.addDetail(category, "Width", () -> "" + size.getWidth());
                MCVer.addDetail(category, "Height", () -> "" + size.getHeight());
                category = crashReport.addCategory("Tooltip details");
                MCVer.addDetail(category, "Element", (Callable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((GuiElement)tooltip));
                MCVer.addDetail(category, "Position", () -> ((ReadablePoint)position).toString());
                MCVer.addDetail(category, "Size", () -> ((ReadableDimension)tooltipSize).toString());
                throw new ReportedException(crashReport);
            }
        }
    }

    @Override
    public ReadableDimension getMinSize() {
        return this.screenSize;
    }

    @Override
    public ReadableDimension getMaxSize() {
        return this.screenSize;
    }

    protected class UserInputGuiScreen
    extends Screen {
        UserInputGuiScreen() {
            super(MCVer.literalText(""));
            ((ScreenExt)((Object)this)).setPassEvents(true);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            boolean shiftDown;
            boolean controlDown;
            Point mousePos = MouseUtils.getMousePos();
            if (!AbstractGuiOverlay.this.invokeHandlers(Typeable.class, arg_0 -> UserInputGuiScreen.lambda$keyPressed$0(mousePos, keyCode, controlDown = UserInputGuiScreen.hasControlDown(), shiftDown = UserInputGuiScreen.hasShiftDown(), arg_0))) {
                return super.keyPressed(keyCode, scanCode, modifiers);
            }
            return true;
        }

        public boolean charTyped(char keyChar, int modifiers) {
            boolean shiftDown;
            boolean controlDown;
            Point mousePos = MouseUtils.getMousePos();
            if (!AbstractGuiOverlay.this.invokeHandlers(Typeable.class, arg_0 -> UserInputGuiScreen.lambda$charTyped$1(mousePos, keyChar, controlDown = UserInputGuiScreen.hasControlDown(), shiftDown = UserInputGuiScreen.hasShiftDown(), arg_0))) {
                return super.charTyped(keyChar, modifiers);
            }
            return true;
        }

        public boolean mouseClicked(double mouseXD, double mouseYD, int mouseButton) {
            int mouseX = (int)Math.round(mouseXD);
            int mouseY = (int)Math.round(mouseYD);
            return AbstractGuiOverlay.this.invokeHandlers(Clickable.class, e -> e.mouseClick((ReadablePoint)new Point(mouseX, mouseY), mouseButton));
        }

        public boolean mouseReleased(double mouseXD, double mouseYD, int mouseButton) {
            int mouseX = (int)Math.round(mouseXD);
            int mouseY = (int)Math.round(mouseYD);
            return AbstractGuiOverlay.this.invokeHandlers(Draggable.class, e -> e.mouseRelease((ReadablePoint)new Point(mouseX, mouseY), mouseButton));
        }

        public boolean mouseDragged(double mouseXD, double mouseYD, int mouseButton, double deltaX, double deltaY) {
            int mouseX = (int)Math.round(mouseXD);
            int mouseY = (int)Math.round(mouseYD);
            long timeSinceLastClick = 0L;
            return AbstractGuiOverlay.this.invokeHandlers(Draggable.class, e -> e.mouseDrag((ReadablePoint)new Point(mouseX, mouseY), mouseButton, timeSinceLastClick));
        }

        public void tick() {
            AbstractGuiOverlay.this.invokeAll(Tickable.class, Tickable::tick);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double dWheelHorizontal, double dWheel) {
            Point mouse = new Point((int)mouseX, (int)mouseY);
            int wheel = (int)(dWheel * 120.0);
            return AbstractGuiOverlay.this.invokeHandlers(Scrollable.class, e -> e.scroll((ReadablePoint)mouse, wheel));
        }

        public void onClose() {
            if (AbstractGuiOverlay.this.closeable) {
                super.onClose();
            }
        }

        public void removed() {
            if (AbstractGuiOverlay.this.closeable) {
                AbstractGuiOverlay.this.mouseVisible = false;
            }
        }

        public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        }

        public AbstractGuiOverlay<T> getOverlay() {
            return AbstractGuiOverlay.this;
        }

        private static /* synthetic */ Boolean lambda$charTyped$1(Point mousePos, char keyChar, boolean controlDown, boolean shiftDown, Typeable e) {
            return e.typeKey((ReadablePoint)mousePos, 0, keyChar, controlDown, shiftDown);
        }

        private static /* synthetic */ Boolean lambda$keyPressed$0(Point mousePos, int keyCode, boolean controlDown, boolean shiftDown, Typeable e) {
            return e.typeKey((ReadablePoint)mousePos, keyCode, '\u0000', controlDown, shiftDown);
        }
    }

    private class EventHandler
    extends EventRegistrations {
        private EventHandler() {
            this.on(RenderHudCallback.EVENT, this::renderOverlay);
            this.on(PreTickCallback.EVENT, () -> AbstractGuiOverlay.this.invokeAll(Tickable.class, Tickable::tick));
        }

        private void renderOverlay(GuiGraphics stack, float partialTicks) {
            AbstractGuiOverlay.this.updateUserInputGui();
            this.updateRenderer();
            int layers = AbstractGuiOverlay.this.getMaxLayer();
            int mouseX = -1;
            int mouseY = -1;
            if (AbstractGuiOverlay.this.mouseVisible) {
                Point mouse = MouseUtils.getMousePos();
                mouseX = mouse.getX();
                mouseY = mouse.getY();
            }
            RenderInfo renderInfo = new RenderInfo(partialTicks, mouseX, mouseY, 0);
            for (int layer = 0; layer <= layers; ++layer) {
                AbstractGuiOverlay.this.layout((ReadableDimension)AbstractGuiOverlay.this.screenSize, renderInfo.layer(layer));
            }
            MinecraftGuiRenderer renderer = new MinecraftGuiRenderer(stack);
            for (int layer = 0; layer <= layers; ++layer) {
                AbstractGuiOverlay.this.draw(renderer, (ReadableDimension)AbstractGuiOverlay.this.screenSize, renderInfo.layer(layer));
            }
        }

        private void updateRenderer() {
            Minecraft mc = AbstractGuiOverlay.this.getMinecraft();
            Window res = MCVer.newScaledResolution(mc);
            if (AbstractGuiOverlay.this.screenSize == null || AbstractGuiOverlay.this.screenSize.getWidth() != res.getGuiScaledWidth() || AbstractGuiOverlay.this.screenSize.getHeight() != res.getGuiScaledHeight()) {
                AbstractGuiOverlay.this.screenSize = new Dimension(res.getGuiScaledWidth(), res.getGuiScaledHeight());
            }
        }
    }
}

