/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiElement;
import de.johni0702.minecraft.gui.element.IGuiClickable;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;

public abstract class AbstractGuiClickable<T extends AbstractGuiClickable<T>>
extends AbstractGuiElement<T>
implements Clickable,
IGuiClickable<T> {
    private Runnable onClick;

    public AbstractGuiClickable() {
    }

    public AbstractGuiClickable(GuiContainer container) {
        super(container);
    }

    @Override
    public boolean mouseClick(ReadablePoint position, int button) {
        Point pos = new Point(position);
        if (this.getContainer() != null) {
            this.getContainer().convertFor(this, pos);
        }
        if (this.isMouseHovering((ReadablePoint)pos) && this.isEnabled()) {
            this.onClick();
            return true;
        }
        return false;
    }

    protected boolean isMouseHovering(ReadablePoint pos) {
        return pos.getX() > 0 && pos.getY() > 0 && pos.getX() < this.getLastSize().getWidth() && pos.getY() < this.getLastSize().getHeight();
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        super.draw(renderer, size, renderInfo);
    }

    protected void onClick() {
        if (this.onClick != null) {
            this.onClick.run();
        }
    }

    @Override
    public T onClick(Runnable onClick) {
        this.onClick = onClick;
        return (T)((AbstractGuiClickable)this.getThis());
    }

    @Override
    public Runnable getOnClick() {
        return this.onClick;
    }
}

