/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiElement;
import de.johni0702.minecraft.gui.element.IGuiTextField;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.function.Focusable;
import de.johni0702.minecraft.gui.function.Tickable;
import de.johni0702.minecraft.gui.function.Typeable;
import de.johni0702.minecraft.gui.utils.Consumer;
import de.johni0702.minecraft.gui.utils.Utils;
import de.johni0702.minecraft.gui.utils.lwjgl.Color;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.versions.MCVer;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.StringUtil;

public abstract class AbstractGuiTextField<T extends AbstractGuiTextField<T>>
extends AbstractGuiElement<T>
implements Clickable,
Tickable,
Typeable,
IGuiTextField<T> {
    private static final ReadableColor BORDER_COLOR = new Color(160, 160, 160);
    private static final ReadableColor CURSOR_COLOR = new Color(240, 240, 240);
    private static final int BORDER = 4;
    private boolean focused;
    private Focusable next;
    private Focusable previous;
    private int maxLength = 32;
    private String text = "";
    private int cursorPos;
    private int selectionPos;
    private String hint;
    private int currentOffset;
    private int blinkCursorTick;
    private ReadableColor textColorEnabled = new Color(224, 224, 224);
    private ReadableColor textColorDisabled = new Color(112, 112, 112);
    private ReadableDimension size = new Dimension(0, 0);
    private Consumer<String> textChanged;
    private Consumer<Boolean> focusChanged;
    private Runnable onEnter;

    public AbstractGuiTextField() {
    }

    public AbstractGuiTextField(GuiContainer container) {
        super(container);
    }

    @Override
    public T setText(String text) {
        if (text.length() > this.maxLength) {
            text = text.substring(0, this.maxLength);
        }
        this.text = text;
        this.selectionPos = this.cursorPos = text.length();
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public T setI18nText(String text, Object ... args) {
        return (T)this.setText(I18n.get((String)text, (Object[])args));
    }

    @Override
    public T setMaxLength(int maxLength) {
        Preconditions.checkArgument((maxLength >= 0 ? 1 : 0) != 0, (Object)"maxLength must not be negative");
        this.maxLength = maxLength;
        if (this.text.length() > maxLength) {
            this.setText(this.text);
        }
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public String deleteText(int from, int to) {
        Preconditions.checkArgument((from <= to ? 1 : 0) != 0, (Object)"from must not be greater than to");
        Preconditions.checkArgument((from >= 0 ? 1 : 0) != 0, (Object)"from must be greater than zero");
        Preconditions.checkArgument((to < this.text.length() ? 1 : 0) != 0, (Object)"to must be less than test.length()");
        String deleted = this.text.substring(from, to + 1);
        this.text = this.text.substring(0, from) + this.text.substring(to + 1);
        return deleted;
    }

    @Override
    public int getSelectionFrom() {
        return this.cursorPos > this.selectionPos ? this.selectionPos : this.cursorPos;
    }

    @Override
    public int getSelectionTo() {
        return this.cursorPos > this.selectionPos ? this.cursorPos : this.selectionPos;
    }

    @Override
    public String getSelectedText() {
        return this.text.substring(this.getSelectionFrom(), this.getSelectionTo());
    }

    @Override
    public String deleteSelectedText() {
        if (this.cursorPos == this.selectionPos) {
            return "";
        }
        int from = this.getSelectionFrom();
        String deleted = this.deleteText(from, this.getSelectionTo() - 1);
        this.cursorPos = this.selectionPos = from;
        return deleted;
    }

    private void updateCurrentOffset() {
        this.currentOffset = Math.min(this.currentOffset, this.cursorPos);
        String line = this.text.substring(this.currentOffset, this.cursorPos);
        Font fontRenderer = MCVer.getFontRenderer();
        int currentWidth = fontRenderer.width(line);
        if (currentWidth > this.size.getWidth() - 8) {
            this.currentOffset = this.cursorPos - fontRenderer.plainSubstrByWidth(line, this.size.getWidth() - 8, true).length();
        }
    }

    @Override
    public T writeText(String append) {
        for (char c : append.toCharArray()) {
            this.writeChar(c);
        }
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public T writeChar(char c) {
        if (!StringUtil.isAllowedChatCharacter((char)c)) {
            return (T)((AbstractGuiTextField)this.getThis());
        }
        this.deleteSelectedText();
        if (this.text.length() >= this.maxLength) {
            return (T)((AbstractGuiTextField)this.getThis());
        }
        this.text = this.text.substring(0, this.cursorPos) + c + this.text.substring(this.cursorPos);
        this.selectionPos = ++this.cursorPos;
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public T deleteNextChar() {
        if (this.cursorPos < this.text.length()) {
            this.text = this.text.substring(0, this.cursorPos) + this.text.substring(this.cursorPos + 1);
        }
        this.selectionPos = this.cursorPos;
        return (T)((AbstractGuiTextField)this.getThis());
    }

    protected int getNextWordLength() {
        int length = 0;
        boolean inWord = true;
        for (int i = this.cursorPos; i < this.text.length(); ++i) {
            if (inWord) {
                if (this.text.charAt(i) == ' ') {
                    inWord = false;
                }
            } else if (this.text.charAt(i) != ' ') {
                return length;
            }
            ++length;
        }
        return length;
    }

    @Override
    public String deleteNextWord() {
        int worldLength = this.getNextWordLength();
        if (worldLength > 0) {
            return this.deleteText(this.cursorPos, this.cursorPos + worldLength - 1);
        }
        return "";
    }

    @Override
    public T deletePreviousChar() {
        if (this.cursorPos > 0) {
            this.text = this.text.substring(0, this.cursorPos - 1) + this.text.substring(this.cursorPos);
            this.selectionPos = --this.cursorPos;
        }
        return (T)((AbstractGuiTextField)this.getThis());
    }

    protected int getPreviousWordLength() {
        int length = 0;
        boolean inWord = false;
        for (int i = this.cursorPos - 1; i >= 0; --i) {
            if (inWord) {
                if (this.text.charAt(i) == ' ') {
                    return length;
                }
            } else if (this.text.charAt(i) != ' ') {
                inWord = true;
            }
            ++length;
        }
        return length;
    }

    @Override
    public String deletePreviousWord() {
        int worldLength = this.getPreviousWordLength();
        String deleted = "";
        if (worldLength > 0) {
            deleted = this.deleteText(this.cursorPos - worldLength, this.cursorPos - 1);
            this.selectionPos = this.cursorPos -= worldLength;
        }
        return deleted;
    }

    @Override
    public T setCursorPosition(int pos) {
        Preconditions.checkArgument((pos >= 0 && pos <= this.text.length() ? 1 : 0) != 0);
        this.selectionPos = this.cursorPos = pos;
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    protected ReadableDimension calcMinSize() {
        return new Dimension(0, 0);
    }

    @Override
    public boolean mouseClick(ReadablePoint position, int button) {
        boolean hovering;
        if (this.getContainer() != null) {
            position = new Point(position);
            this.getContainer().convertFor(this, (Point)position);
        }
        if ((hovering = this.isMouseHovering(position)) && this.isFocused() && button == 0) {
            this.updateCurrentOffset();
            int mouseX = position.getX() - 4;
            Font fontRenderer = MCVer.getFontRenderer();
            String text = this.text.substring(this.currentOffset);
            int textX = fontRenderer.plainSubstrByWidth(text, mouseX).length() + this.currentOffset;
            this.setCursorPosition(textX);
            return true;
        }
        this.setFocused(hovering);
        return false;
    }

    protected boolean isMouseHovering(ReadablePoint pos) {
        return pos.getX() > 0 && pos.getY() > 0 && pos.getX() < this.size.getWidth() && pos.getY() < this.size.getHeight();
    }

    @Override
    public T setFocused(boolean isFocused) {
        if (isFocused && !this.focused) {
            this.blinkCursorTick = 0;
        }
        if (this.focused != isFocused) {
            this.focused = isFocused;
            this.onFocusChanged(this.focused);
        }
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public T setNext(Focusable next) {
        this.next = next;
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public T setPrevious(Focusable previous) {
        this.previous = previous;
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        this.size = size;
        this.updateCurrentOffset();
        super.draw(renderer, size, renderInfo);
        int width = size.getWidth();
        int height = size.getHeight();
        Font fontRenderer = MCVer.getFontRenderer();
        int n = height / 2;
        Objects.requireNonNull(fontRenderer);
        int posY = n - 9 / 2;
        renderer.drawRect(0, 0, width, height, this.isFocused() ? ReadableColor.WHITE : BORDER_COLOR);
        renderer.drawRect(1, 1, width - 2, height - 2, ReadableColor.BLACK);
        if (this.text.isEmpty() && !this.isFocused() && !Strings.isNullOrEmpty((String)this.hint)) {
            String text = fontRenderer.plainSubstrByWidth(this.hint, width - 8);
            renderer.drawString(4, posY, this.textColorDisabled, text);
        } else {
            String renderText = this.text.substring(this.currentOffset);
            renderText = fontRenderer.plainSubstrByWidth(renderText, width - 8);
            ReadableColor color = this.isEnabled() ? this.textColorEnabled : this.textColorDisabled;
            int n2 = height / 2;
            Objects.requireNonNull(fontRenderer);
            int lineEnd = renderer.drawString(4, n2 - 9 / 2, color, renderText);
            int from = this.getSelectionFrom();
            int to = this.getSelectionTo();
            String leftStr = renderText.substring(0, Utils.clamp(from - this.currentOffset, 0, renderText.length()));
            String rightStr = renderText.substring(Utils.clamp(to - this.currentOffset, 0, renderText.length()));
            int left = 4 + fontRenderer.width(leftStr);
            int right = lineEnd - fontRenderer.width(rightStr) - 1;
            renderer.invertColors(right, height - 2, left, 2);
            if (this.blinkCursorTick / 6 % 2 == 0 && this.focused) {
                String beforeCursor = renderText.substring(0, this.cursorPos - this.currentOffset);
                int posX = 4 + fontRenderer.width(beforeCursor);
                if (this.cursorPos == this.text.length()) {
                    renderer.drawString(posX, posY, CURSOR_COLOR, "_", true);
                } else {
                    Objects.requireNonNull(fontRenderer);
                    renderer.drawRect(posX, posY - 1, 1, 1 + 9, CURSOR_COLOR);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean typeKey(ReadablePoint mousePosition, int keyCode, char keyChar, boolean ctrlDown, boolean shiftDown) {
        if (!this.focused) {
            return false;
        }
        if (keyCode == 258) {
            Focusable other;
            Focusable focusable = other = shiftDown ? this.previous : this.next;
            if (other != null) {
                this.setFocused(false);
                other.setFocused(true);
                if (other instanceof AbstractGuiTextField) {
                    AbstractGuiTextField field = (AbstractGuiTextField)other;
                    field.cursorPos = 0;
                    field.selectionPos = field.text.length();
                }
            }
            return true;
        }
        if (keyCode == 257) {
            this.onEnter();
            return true;
        }
        String textBefore = this.text;
        try {
            if (Screen.hasControlDown()) {
                switch (keyCode) {
                    case 65: {
                        this.cursorPos = 0;
                        this.selectionPos = this.text.length();
                        boolean field = true;
                        return field;
                    }
                    case 67: {
                        MCVer.setClipboardString(this.getSelectedText());
                        boolean field = true;
                        return field;
                    }
                    case 86: {
                        if (this.isEnabled()) {
                            this.writeText(MCVer.getClipboardString());
                        }
                        boolean field = true;
                        return field;
                    }
                    case 88: {
                        if (this.isEnabled()) {
                            MCVer.setClipboardString(this.deleteSelectedText());
                        }
                        boolean field = true;
                        return field;
                    }
                }
            }
            boolean words = Screen.hasControlDown();
            boolean select = Screen.hasShiftDown();
            switch (keyCode) {
                case 268: {
                    this.cursorPos = 0;
                    break;
                }
                case 269: {
                    this.cursorPos = this.text.length();
                    break;
                }
                case 263: {
                    if (this.cursorPos == 0) break;
                    if (words) {
                        this.cursorPos -= this.getPreviousWordLength();
                        break;
                    }
                    --this.cursorPos;
                    break;
                }
                case 262: {
                    if (this.cursorPos == this.text.length()) break;
                    if (words) {
                        this.cursorPos += this.getNextWordLength();
                        break;
                    }
                    ++this.cursorPos;
                    break;
                }
                case 259: {
                    if (this.isEnabled()) {
                        if (this.getSelectedText().length() > 0) {
                            this.deleteSelectedText();
                        } else if (words) {
                            this.deletePreviousWord();
                        } else {
                            this.deletePreviousChar();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                case 261: {
                    if (this.isEnabled()) {
                        if (this.getSelectedText().length() > 0) {
                            this.deleteSelectedText();
                        } else if (words) {
                            this.deleteNextWord();
                        } else {
                            this.deleteNextChar();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                default: {
                    if (this.isEnabled()) {
                        if (keyChar == '\r') {
                            keyChar = (char)10;
                        }
                        this.writeChar(keyChar);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            if (!select) {
                this.selectionPos = this.cursorPos;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (!textBefore.equals(this.text)) {
                this.onTextChanged(textBefore);
            }
        }
    }

    @Override
    public void tick() {
        ++this.blinkCursorTick;
    }

    protected void onEnter() {
        if (this.onEnter != null) {
            this.onEnter.run();
        }
    }

    protected void onTextChanged(String from) {
        if (this.textChanged != null) {
            this.textChanged.consume(from);
        }
    }

    protected void onFocusChanged(boolean focused) {
        if (this.focusChanged != null) {
            this.focusChanged.consume(focused);
        }
    }

    @Override
    public T onEnter(Runnable onEnter) {
        this.onEnter = onEnter;
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public T onTextChanged(Consumer<String> textChanged) {
        this.textChanged = textChanged;
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public T onFocusChange(Consumer<Boolean> focusChanged) {
        this.focusChanged = focusChanged;
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public T setHint(String hint) {
        this.hint = hint;
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public T setI18nHint(String hint, Object ... args) {
        return (T)this.setHint(I18n.get((String)hint, (Object[])new Object[0]));
    }

    @Override
    public ReadableColor getTextColor() {
        return this.textColorEnabled;
    }

    @Override
    public T setTextColor(ReadableColor textColor) {
        this.textColorEnabled = textColor;
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public ReadableColor getTextColorDisabled() {
        return this.textColorDisabled;
    }

    @Override
    public T setTextColorDisabled(ReadableColor textColorDisabled) {
        this.textColorDisabled = textColorDisabled;
        return (T)((AbstractGuiTextField)this.getThis());
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public Focusable getNext() {
        return this.next;
    }

    @Override
    public Focusable getPrevious() {
        return this.previous;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getHint() {
        return this.hint;
    }
}

