/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element.advanced;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.OffsetGuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.element.AbstractComposedGuiElement;
import de.johni0702.minecraft.gui.element.AbstractGuiClickable;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.IGuiClickable;
import de.johni0702.minecraft.gui.element.advanced.IGuiDropdownMenu;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.layout.VerticalLayout;
import de.johni0702.minecraft.gui.utils.Consumer;
import de.johni0702.minecraft.gui.utils.lwjgl.Color;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.versions.MCVer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.gui.Font;

public abstract class AbstractGuiDropdownMenu<V, T extends AbstractGuiDropdownMenu<V, T>>
extends AbstractComposedGuiElement<T>
implements IGuiDropdownMenu<V, T>,
Clickable {
    private static final ReadableColor OUTLINE_COLOR = new Color(160, 160, 160);
    private int selected;
    private V[] values;
    private boolean opened;
    private Consumer<Integer> onSelection;
    private GuiPanel dropdown;
    private Map<V, IGuiClickable> unmodifiableDropdownEntries;
    private Function<V, String> toString = Object::toString;

    public AbstractGuiDropdownMenu() {
    }

    public AbstractGuiDropdownMenu(GuiContainer container) {
        super(container);
    }

    @Override
    public int getMaxLayer() {
        return this.opened ? 1 : 0;
    }

    @Override
    protected ReadableDimension calcMinSize() {
        Font fontRenderer = MCVer.getFontRenderer();
        int maxWidth = 0;
        for (V value : this.values) {
            int width = fontRenderer.width(this.toString.apply(value));
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        Objects.requireNonNull(fontRenderer);
        Objects.requireNonNull(fontRenderer);
        return new Dimension(11 + maxWidth + 9, 9 + 4);
    }

    @Override
    public void layout(ReadableDimension size, RenderInfo renderInfo) {
        super.layout(size, renderInfo);
        Font fontRenderer = MCVer.getFontRenderer();
        if (renderInfo.layer == 1) {
            Point offsetPoint = new Point(0, size.getHeight());
            int n = size.getWidth();
            Objects.requireNonNull(fontRenderer);
            Dimension offsetSize = new Dimension(n, (9 + 5) * this.values.length);
            this.dropdown.layout((ReadableDimension)offsetSize, renderInfo.offsetMouse(0, offsetPoint.getY()).layer(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        super.draw(renderer, size, renderInfo);
        Font fontRenderer = MCVer.getFontRenderer();
        if (renderInfo.layer == 0) {
            int width = size.getWidth();
            int height = size.getHeight();
            renderer.drawRect(0, 0, width, height, OUTLINE_COLOR);
            renderer.drawRect(1, 1, width - 2, height - 2, ReadableColor.BLACK);
            renderer.drawRect(width - height, 0, 1, height, OUTLINE_COLOR);
            int base = height - 6;
            int tHeight = base / 2;
            int x = width - 3 - base / 2;
            int y = height / 2 - 2;
            for (int layer = tHeight; layer > 0; --layer) {
                renderer.drawRect(x - layer, y + (tHeight - layer), layer * 2 - 1, 1, OUTLINE_COLOR);
            }
            int n = height / 2;
            Objects.requireNonNull(fontRenderer);
            renderer.drawString(3, n - 9 / 2, ReadableColor.WHITE, this.toString.apply(this.getSelectedValue()));
        } else if (renderInfo.layer == 1) {
            Point offsetPoint = new Point(0, size.getHeight());
            int n = size.getWidth();
            Objects.requireNonNull(fontRenderer);
            Dimension offsetSize = new Dimension(n, (9 + 5) * this.values.length);
            OffsetGuiRenderer offsetRenderer = new OffsetGuiRenderer(renderer, (ReadablePoint)offsetPoint, (ReadableDimension)offsetSize);
            offsetRenderer.startUsing();
            try {
                this.dropdown.draw(offsetRenderer, (ReadableDimension)offsetSize, renderInfo.offsetMouse(0, offsetPoint.getY()).layer(0));
            }
            finally {
                offsetRenderer.stopUsing();
            }
        }
    }

    @Override
    public T setValues(V ... values) {
        this.values = values;
        this.dropdown = (GuiPanel)new GuiPanel(){

            @Override
            public void convertFor(GuiElement element, Point point, int relativeLayer) {
                AbstractGuiDropdownMenu parent = AbstractGuiDropdownMenu.this;
                if (parent.getContainer() != null) {
                    parent.getContainer().convertFor(parent, point, relativeLayer + 1);
                }
                point.translate(0, -AbstractGuiDropdownMenu.this.getLastSize().getHeight());
                super.convertFor(element, point, relativeLayer);
            }
        }.setLayout(new VerticalLayout());
        LinkedHashMap<V, DropdownEntry> dropdownEntries = new LinkedHashMap<V, DropdownEntry>();
        for (V value : values) {
            DropdownEntry entry = new DropdownEntry(value);
            dropdownEntries.put(value, entry);
            this.dropdown.addElements(null, new GuiElement[]{entry});
        }
        this.unmodifiableDropdownEntries = Collections.unmodifiableMap(dropdownEntries);
        return (T)((AbstractGuiDropdownMenu)this.getThis());
    }

    @Override
    public T setSelected(int selected) {
        this.selected = selected;
        this.onSelection(selected);
        return (T)((AbstractGuiDropdownMenu)this.getThis());
    }

    @Override
    public T setSelected(V value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(value)) continue;
            return (T)this.setSelected(i);
        }
        throw new IllegalArgumentException("The value " + String.valueOf(value) + " is not in this dropdown menu.");
    }

    @Override
    public V getSelectedValue() {
        return this.values[this.selected];
    }

    @Override
    public T setOpened(boolean opened) {
        this.opened = opened;
        return (T)((AbstractGuiDropdownMenu)this.getThis());
    }

    @Override
    public Collection<GuiElement> getChildren() {
        return this.opened ? Collections.singletonList(this.dropdown) : Collections.emptyList();
    }

    @Override
    public T onSelection(Consumer<Integer> consumer) {
        this.onSelection = consumer;
        return (T)((AbstractGuiDropdownMenu)this.getThis());
    }

    public void onSelection(Integer value) {
        if (this.onSelection != null) {
            this.onSelection.consume(value);
        }
    }

    @Override
    public boolean mouseClick(ReadablePoint position, int button) {
        Point pos = new Point(position);
        if (this.getContainer() != null) {
            this.getContainer().convertFor(this, pos);
        }
        if (this.isEnabled() && this.isMouseHovering((ReadablePoint)pos)) {
            this.setOpened(!this.isOpened());
            return true;
        }
        return false;
    }

    protected boolean isMouseHovering(ReadablePoint pos) {
        return pos.getX() > 0 && pos.getY() > 0 && pos.getX() < this.getLastSize().getWidth() && pos.getY() < this.getLastSize().getHeight();
    }

    @Override
    public Map<V, IGuiClickable> getDropdownEntries() {
        return this.unmodifiableDropdownEntries;
    }

    @Override
    public T setToString(Function<V, String> toString) {
        this.toString = toString;
        return (T)((AbstractGuiDropdownMenu)this.getThis());
    }

    @Override
    public int getSelected() {
        return this.selected;
    }

    @Override
    public V[] getValues() {
        return this.values;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    private class DropdownEntry
    extends AbstractGuiClickable<DropdownEntry> {
        private final V value;

        public DropdownEntry(V value) {
            this.value = value;
        }

        @Override
        protected DropdownEntry getThis() {
            return this;
        }

        @Override
        protected ReadableDimension calcMinSize() {
            Objects.requireNonNull(MCVer.getFontRenderer());
            return new Dimension(0, 9 + 5);
        }

        @Override
        public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
            super.draw(renderer, size, renderInfo);
            int width = size.getWidth();
            int height = size.getHeight();
            renderer.drawRect(0, 0, width, height, OUTLINE_COLOR);
            renderer.drawRect(1, 0, width - 2, height - 1, ReadableColor.BLACK);
            renderer.drawString(3, 2, ReadableColor.WHITE, AbstractGuiDropdownMenu.this.toString.apply(this.value));
        }

        @Override
        public boolean mouseClick(ReadablePoint position, int button) {
            boolean result = super.mouseClick(position, button);
            AbstractGuiDropdownMenu.this.setOpened(false);
            return result;
        }

        @Override
        protected void onClick() {
            AbstractGuiDropdownMenu.this.setSelected(this.value);
        }
    }
}

