/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element.advanced;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.AbstractGuiVerticalList;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.function.Closeable;
import de.johni0702.minecraft.gui.function.Loadable;
import de.johni0702.minecraft.gui.function.Tickable;
import de.johni0702.minecraft.gui.function.Typeable;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.layout.VerticalLayout;
import de.johni0702.minecraft.gui.utils.Colors;
import de.johni0702.minecraft.gui.utils.Consumer;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;

public abstract class AbstractGuiResourceLoadingList<T extends AbstractGuiResourceLoadingList<T, U>, U extends GuiElement<U> & Comparable<U>>
extends AbstractGuiVerticalList<T>
implements Tickable,
Loadable,
Closeable,
Typeable {
    private static final String[] LOADING_TEXT = new String[]{"Ooo", "oOo", "ooO", "oOo"};
    private final GuiLabel loadingElement = new GuiLabel();
    private final GuiPanel resourcesPanel = (GuiPanel)new GuiPanel(this.getListPanel()).setLayout(new VerticalLayout());
    private final Queue<Runnable> resourcesQueue = new ConcurrentLinkedQueue<Runnable>();
    private Consumer<Consumer<Supplier<U>>> onLoad;
    private Runnable onSelectionChanged;
    private Runnable onSelectionDoubleClicked;
    private Thread loaderThread;
    private int tick;
    private final List<Element> selected = new ArrayList<Element>();
    private long selectedLastClickTime;

    public AbstractGuiResourceLoadingList() {
    }

    public AbstractGuiResourceLoadingList(GuiContainer container) {
        super(container);
    }

    @Override
    public void tick() {
        Runnable resource;
        this.loadingElement.setText(LOADING_TEXT[this.tick++ / 5 % LOADING_TEXT.length]);
        while ((resource = this.resourcesQueue.poll()) != null) {
            resource.run();
        }
    }

    @Override
    public void load() {
        if (this.loaderThread != null) {
            this.loaderThread.interrupt();
            try {
                this.loaderThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        this.resourcesQueue.clear();
        for (GuiElement element : new ArrayList<GuiElement>(this.resourcesPanel.getChildren())) {
            this.resourcesPanel.removeElement(element);
        }
        this.selected.clear();
        this.onSelectionChanged();
        this.loaderThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractGuiResourceLoadingList.this.onLoad.consume(new Consumer<Supplier<U>>(){

                        @Override
                        public void consume(final Supplier<U> obj) {
                            AbstractGuiResourceLoadingList.this.resourcesQueue.offer(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractGuiResourceLoadingList.this.resourcesPanel.addElements(null, new GuiElement[]{new Element(AbstractGuiResourceLoadingList.this, (GuiElement)obj.get())});
                                    AbstractGuiResourceLoadingList.this.resourcesPanel.sortElements();
                                }
                            });
                        }
                    });
                    AbstractGuiResourceLoadingList.this.resourcesQueue.offer(new Runnable(){

                        @Override
                        public void run() {
                            AbstractGuiResourceLoadingList.this.getListPanel().removeElement(AbstractGuiResourceLoadingList.this.loadingElement);
                        }
                    });
                }
                catch (Throwable throwable) {
                    AbstractGuiResourceLoadingList.this.resourcesQueue.offer(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
        });
        this.getListPanel().addElements(new VerticalLayout.Data(0.5), new GuiElement[]{this.loadingElement});
        this.loaderThread.start();
    }

    @Override
    public void close() {
        this.loaderThread.interrupt();
    }

    public T onLoad(Consumer<Consumer<Supplier<U>>> function) {
        this.onLoad = function;
        return (T)((AbstractGuiResourceLoadingList)this.getThis());
    }

    public void onSelectionChanged() {
        if (this.onSelectionChanged != null) {
            this.onSelectionChanged.run();
        }
    }

    public void onSelectionDoubleClicked() {
        if (this.onSelectionDoubleClicked != null) {
            this.onSelectionDoubleClicked.run();
        }
    }

    public T onSelectionChanged(Runnable onSelectionChanged) {
        this.onSelectionChanged = onSelectionChanged;
        return (T)((AbstractGuiResourceLoadingList)this.getThis());
    }

    public T onSelectionDoubleClicked(Runnable onSelectionDoubleClicked) {
        this.onSelectionDoubleClicked = onSelectionDoubleClicked;
        return (T)((AbstractGuiResourceLoadingList)this.getThis());
    }

    public List<U> getSelected() {
        ArrayList selectedResources = new ArrayList(this.selected.size());
        for (Element element : this.selected) {
            selectedResources.add(element.resource);
        }
        return selectedResources;
    }

    @Override
    public boolean typeKey(ReadablePoint mousePosition, int keyCode, char keyChar, boolean ctrlDown, boolean shiftDown) {
        if (Screen.hasControlDown() && keyCode == 65) {
            ArrayList<Element> all = new ArrayList<Element>();
            for (GuiElement child : this.getListPanel().getChildren()) {
                if (!(child instanceof Element)) continue;
                all.add((Element)child);
            }
            if (this.selected.size() < all.size()) {
                this.selected.clear();
                this.selected.addAll(all);
            } else {
                this.selected.clear();
            }
            this.onSelectionChanged();
            return true;
        }
        return false;
    }

    private static class Element
    extends GuiPanel
    implements Clickable,
    Comparable<Element> {
        private final U resource;
        final /* synthetic */ AbstractGuiResourceLoadingList this$0;

        public Element(final U resource) {
            this.this$0 = var1_1;
            this.resource = resource;
            this.addElements(null, new GuiElement[]{resource});
            this.setLayout(new CustomLayout<GuiPanel>(this){

                @Override
                protected void layout(GuiPanel container, int width, int height) {
                    this.pos(resource, 2, 2);
                }

                @Override
                public ReadableDimension calcMinSize(GuiContainer<?> container) {
                    ReadableDimension size = resource.getMinSize();
                    return new Dimension(size.getWidth() + 4, size.getHeight() + 4);
                }
            });
        }

        @Override
        public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
            if (renderInfo.layer == 0 && this.this$0.selected.contains(this)) {
                int w = size.getWidth();
                int h = size.getHeight();
                renderer.drawRect(0, 0, w, h, Colors.BLACK);
                renderer.drawRect(0, 0, w, 1, Colors.LIGHT_GRAY);
                renderer.drawRect(0, h - 1, w, 1, Colors.LIGHT_GRAY);
                renderer.drawRect(0, 0, 1, h, Colors.LIGHT_GRAY);
                renderer.drawRect(w - 1, 0, 1, h, Colors.LIGHT_GRAY);
            }
            super.draw(renderer, size, renderInfo);
        }

        @Override
        public boolean mouseClick(ReadablePoint position, int button) {
            Point point = new Point(position);
            this.getContainer().convertFor(this, point);
            if (point.getX() > 0 && point.getX() < this.getLastSize().getWidth() && point.getY() > 0 && point.getY() < this.getLastSize().getHeight()) {
                if (Screen.hasControlDown()) {
                    if (this.this$0.selected.contains(this)) {
                        this.this$0.selected.remove(this);
                    } else {
                        this.this$0.selected.add(this);
                    }
                    this.this$0.onSelectionChanged();
                } else if (this.this$0.selected.contains(this) && System.currentTimeMillis() - this.this$0.selectedLastClickTime < 250L) {
                    this.this$0.onSelectionDoubleClicked();
                } else {
                    this.this$0.selected.clear();
                    this.this$0.selected.add(this);
                    this.this$0.onSelectionChanged();
                }
                this.this$0.selectedLastClickTime = System.currentTimeMillis();
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(Element o) {
            return ((Comparable)this.resource).compareTo(o.resource);
        }
    }
}

