/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element.advanced;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiElement;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiTooltip;
import de.johni0702.minecraft.gui.element.advanced.IGuiTimeline;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.utils.Colors;
import de.johni0702.minecraft.gui.utils.Utils;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;

public abstract class AbstractGuiTimeline<T extends AbstractGuiTimeline<T>>
extends AbstractGuiElement<T>
implements IGuiTimeline<T>,
Clickable {
    protected static final int TEXTURE_WIDTH = 64;
    protected static final int TEXTURE_HEIGHT = 22;
    protected static final int TEXTURE_X = 0;
    protected static final int TEXTURE_Y = 16;
    protected static final int BORDER_LEFT = 4;
    protected static final int BORDER_RIGHT = 4;
    protected static final int BORDER_TOP = 4;
    protected static final int BORDER_BOTTOM = 3;
    protected static final int MARKER_MIN_DISTANCE = 40;
    private IGuiTimeline.OnClick onClick;
    private int length;
    private int cursorPosition;
    private double zoom = 1.0;
    private int offset;
    private boolean drawCursor = true;
    private boolean drawMarkers;
    @Deprecated
    protected ReadableDimension size;

    public AbstractGuiTimeline() {
        this.setTooltip((GuiElement)new GuiTooltip(){

            @Override
            public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
                this.setText(AbstractGuiTimeline.this.getTooltipText(renderInfo));
                super.draw(renderer, size, renderInfo);
            }
        }.setText("00:00"));
    }

    public AbstractGuiTimeline(GuiContainer container) {
        super(container);
        this.setTooltip((GuiElement)new /* invalid duplicate definition of identical inner class */.setText("00:00"));
    }

    protected String getTooltipText(RenderInfo renderInfo) {
        int ms = this.getTimeAt(renderInfo.mouseX, renderInfo.mouseY);
        int s = ms / 1000 % 60;
        int m = ms / 1000 / 60;
        return String.format("%02d:%02d", m, s);
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        this.size = size;
        super.draw(renderer, size, renderInfo);
        int width = size.getWidth();
        int height = size.getHeight();
        renderer.bindTexture(TEXTURE);
        Utils.drawDynamicRect(renderer, width, height, 0, 16, 64, 22, 5, 3, 5, 4);
        if (this.drawMarkers) {
            this.drawMarkers(renderer, size);
        }
        this.drawTimelineCursor(renderer, size);
    }

    protected void drawTimelineCursor(GuiRenderer renderer, ReadableDimension size) {
        if (!this.drawCursor) {
            return;
        }
        int height = size.getHeight();
        renderer.bindTexture(TEXTURE);
        int visibleLength = (int)((double)this.length * this.zoom);
        int cursor = Utils.clamp(this.cursorPosition, this.offset, this.offset + visibleLength);
        double positionInVisible = cursor - this.offset;
        double fractionOfVisible = positionInVisible / (double)visibleLength;
        int cursorX = (int)(4.0 + fractionOfVisible * (double)(size.getWidth() - 4 - 4));
        renderer.drawTexturedRect(cursorX - 2, 3, 64, 0, 5, 4);
        for (int y = 3; y < height - 3; y += 11) {
            int segmentHeight = Math.min(11, height - 3 - y);
            renderer.drawTexturedRect(cursorX - 2, y, 64, 4, 5, segmentHeight);
        }
    }

    protected void drawMarkers(GuiRenderer renderer, ReadableDimension size) {
        int visibleLength = (int)((double)this.length * this.zoom);
        int markerInterval = this.getMarkerInterval();
        int smallInterval = Math.max(markerInterval / 5, 1);
        for (int time = this.offset / markerInterval * markerInterval; time <= this.offset + visibleLength; time += smallInterval) {
            if (time < this.offset) continue;
            this.drawMarker(renderer, size, time, time % markerInterval == 0);
        }
    }

    protected void drawMarker(GuiRenderer renderer, ReadableDimension size, int time, boolean big) {
        int visibleLength = (int)((double)this.length * this.zoom);
        double positionInVisible = time - this.offset;
        double fractionOfVisible = positionInVisible / (double)visibleLength;
        int positionX = (int)(4.0 + fractionOfVisible * (double)(size.getWidth() - 4 - 4));
        int height = size.getHeight() / (big ? 3 : 6);
        ReadableColor color = big ? Colors.LIGHT_GRAY : Colors.WHITE;
        renderer.drawRect(positionX, size.getHeight() - 3 - height, 1, height, color);
    }

    protected int getTimeAt(int mouseX, int mouseY) {
        if (this.getLastSize() == null) {
            return -1;
        }
        Point mouse = new Point(mouseX, mouseY);
        this.getContainer().convertFor(this, mouse);
        mouseX = mouse.getX();
        mouseY = mouse.getY();
        if (mouseX < 0 || mouseY < 0 || mouseX > this.size.getWidth() || mouseY > this.size.getHeight()) {
            return -1;
        }
        int width = this.size.getWidth();
        int bodyWidth = width - 4 - 4;
        double segmentLength = (double)this.length * this.zoom;
        double segmentTime = segmentLength * (double)(mouseX - 4) / (double)bodyWidth;
        return Math.min(Math.max((int)Math.round((double)this.offset + segmentTime), 0), this.length);
    }

    public void onClick(int time) {
        if (this.onClick != null) {
            this.onClick.run(time);
        }
    }

    @Override
    public ReadableDimension calcMinSize() {
        return new Dimension(0, 0);
    }

    @Override
    public T setLength(int length) {
        this.length = length;
        return (T)((AbstractGuiTimeline)this.getThis());
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public T setCursorPosition(int position) {
        this.cursorPosition = Math.min(Math.max(position, 0), this.length);
        return (T)((AbstractGuiTimeline)this.getThis());
    }

    @Override
    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public T ensureCursorVisible() {
        return this.ensureCursorVisible(0);
    }

    public T ensureCursorVisibleWithPadding() {
        return this.ensureCursorVisible(Math.max((int)((double)this.length * this.zoom) / 10, 10));
    }

    public T ensureCursorVisible(int padding) {
        int visibleLength = (int)((double)this.length * this.zoom);
        if (this.cursorPosition - padding < this.offset) {
            this.setOffset(this.cursorPosition - padding);
        } else if (this.cursorPosition + padding > this.offset + visibleLength) {
            this.setOffset(this.cursorPosition + padding - visibleLength);
        }
        return (T)((AbstractGuiTimeline)this.getThis());
    }

    @Override
    public T setZoom(double zoom) {
        this.zoom = Math.min(zoom, 1.0);
        this.checkOffset();
        return (T)((AbstractGuiTimeline)this.getThis());
    }

    @Override
    public double getZoom() {
        return this.zoom;
    }

    @Override
    public T setOffset(int offset) {
        this.offset = Math.max(offset, 0);
        this.checkOffset();
        return (T)((AbstractGuiTimeline)this.getThis());
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public T onClick(IGuiTimeline.OnClick onClick) {
        this.onClick = onClick;
        return (T)((AbstractGuiTimeline)this.getThis());
    }

    @Override
    public boolean mouseClick(ReadablePoint position, int button) {
        int time = this.getTimeAt(position.getX(), position.getY());
        if (time != -1) {
            this.onClick(time);
            return true;
        }
        return false;
    }

    @Override
    public boolean getMarkers() {
        return this.drawMarkers;
    }

    @Override
    public T setMarkers(boolean active) {
        this.drawMarkers = active;
        return (T)((AbstractGuiTimeline)this.getThis());
    }

    @Override
    public T setMarkers() {
        return (T)this.setMarkers(true);
    }

    @Override
    public int getMarkerInterval() {
        int[] snapTo;
        if (this.size == null) {
            return this.length;
        }
        int width = this.size.getWidth() - 4 - 4;
        double segmentLength = (double)this.length * this.zoom;
        int markerMinDistance = (int)(40.0 * (this.length > 3600000 ? 1.2 : 1.0));
        int maxMarkers = width / markerMinDistance;
        int minInterval = (int)(segmentLength / (double)maxMarkers);
        int S2 = 1000;
        int M = 60000;
        int H = 3600000;
        for (int snap : snapTo = new int[]{1000, 2000, 5000, 10000, 15000, 20000, 30000, 60000, 120000, 300000, 600000, 900000, 1800000, 3600000, 0x6DDD00, 18000000, 36000000}) {
            if (snap <= minInterval) continue;
            return snap;
        }
        return snapTo[snapTo.length - 1];
    }

    @Override
    public T setCursor(boolean active) {
        this.drawCursor = active;
        return (T)((AbstractGuiTimeline)this.getThis());
    }

    @Override
    public boolean getCursor() {
        return this.drawCursor;
    }

    private void checkOffset() {
        int visibleLength = (int)((double)this.length * this.zoom);
        if (visibleLength + this.offset > this.length) {
            this.offset = this.length - visibleLength;
        }
    }

    @Override
    protected ReadableDimension getLastSize() {
        return super.getLastSize();
    }
}

