/*
 * Decompiled with CFR 0.152.
 */
package morethanhidden.restrictedportals;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import morethanhidden.restrictedportals.Constants;
import org.apache.commons.io.FileUtils;

public class AdvancementHelper {
    public static void AddCustomAdvancement(String title, String description, String item, String shortname, String path) {
        JsonObject iconItem = new JsonObject();
        iconItem.add("id", (JsonElement)new JsonPrimitive(item));
        JsonObject jitem = new JsonObject();
        JsonArray jitems = new JsonArray();
        jitems.add(item);
        jitem.add("items", (JsonElement)jitems);
        JsonObject display = new JsonObject();
        display.add("icon", (JsonElement)iconItem);
        display.add("title", (JsonElement)new JsonPrimitive(title));
        display.add("description", (JsonElement)new JsonPrimitive(description));
        JsonArray itemarray = new JsonArray();
        itemarray.add((JsonElement)jitem);
        JsonObject items = new JsonObject();
        items.add("items", (JsonElement)itemarray);
        JsonObject crit1 = new JsonObject();
        crit1.add("trigger", (JsonElement)new JsonPrimitive("minecraft:inventory_changed"));
        crit1.add("conditions", (JsonElement)items);
        JsonObject criteria = new JsonObject();
        criteria.add(shortname, (JsonElement)crit1);
        JsonArray requirements = new JsonArray();
        JsonArray requirementArray = new JsonArray();
        requirementArray.add(shortname);
        requirements.add((JsonElement)requirementArray);
        JsonObject jo = new JsonObject();
        jo.add("display", (JsonElement)display);
        jo.add("parent", (JsonElement)new JsonPrimitive("restrictedportals:root"));
        jo.add("criteria", (JsonElement)criteria);
        jo.add("requirements", (JsonElement)requirements);
        File file = new File(path + "/restrictedportals/data/restrictedportals/advancement/" + shortname + ".json");
        try {
            if (file.createNewFile()) {
                Constants.LOGGER.info("Created Json File: " + file.getPath());
            } else {
                Constants.LOGGER.info("File already Exists: " + file.getPath());
            }
        }
        catch (IOException e) {
            Constants.LOGGER.info("Creating file failed: " + file.getPath());
        }
        try {
            FileWriter fileWriter = new FileWriter(file.getPath());
            fileWriter.write(jo.toString());
            fileWriter.close();
        }
        catch (IOException e) {
            Constants.LOGGER.info("Editing File Failed: " + file.getPath());
        }
    }

    public static void ClearCustomAdvancements(String path) {
        try {
            FileUtils.cleanDirectory((File)new File(path + "/restrictedportals/data/restrictedportals/advancements"));
        }
        catch (Exception e) {
            Constants.LOGGER.info("Failed to clean Advancements Folder");
        }
    }

    public static void CreateDatapack(String path) {
        File folder;
        File datapackFolder = new File(path);
        if (datapackFolder.mkdir()) {
            Constants.LOGGER.info("Created DataPack Folder: " + datapackFolder.getPath());
        }
        if ((folder = new File(path + "/restrictedportals")).mkdir()) {
            Constants.LOGGER.info("Created DataPack Folder: " + folder.getPath());
        } else {
            Constants.LOGGER.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
        JsonObject pack = new JsonObject();
        pack.add("description", (JsonElement)new JsonPrimitive("restrictedportals datapack"));
        pack.add("pack_format", (JsonElement)new JsonPrimitive((Number)6));
        JsonObject mcmeta = new JsonObject();
        mcmeta.add("pack", (JsonElement)pack);
        File file = new File(path + "/restrictedportals/pack.mcmeta");
        try {
            if (file.createNewFile()) {
                Constants.LOGGER.info("Created Data Pack mcmeta: " + file.getPath());
            } else {
                Constants.LOGGER.info("File already Exists: " + file.getPath());
            }
        }
        catch (IOException e) {
            Constants.LOGGER.info("Creating file failed: " + file.getPath());
        }
        try {
            FileWriter fileWriter = new FileWriter(file.getPath());
            fileWriter.write(mcmeta.toString());
            fileWriter.close();
        }
        catch (IOException e) {
            Constants.LOGGER.info("Editing File Failed: " + file.getPath());
        }
        folder = new File(path + "/restrictedportals/data");
        if (folder.mkdir()) {
            Constants.LOGGER.info("Created DataPack Folder: " + folder.getPath());
        } else {
            Constants.LOGGER.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
        folder = new File(path + "/restrictedportals/data/restrictedportals");
        if (folder.mkdir()) {
            Constants.LOGGER.info("Created DataPack Folder: " + folder.getPath());
        } else {
            Constants.LOGGER.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
        folder = new File(path + "/restrictedportals/data/restrictedportals/advancement");
        if (folder.mkdir()) {
            Constants.LOGGER.info("Created DataPack Folder: " + folder.getPath());
        } else {
            Constants.LOGGER.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
    }
}

