/*
 * Decompiled with CFR 0.152.
 */
package morethanhidden.restrictedportals;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import morethanhidden.restrictedportals.AdvancementHelper;
import morethanhidden.restrictedportals.platform.services.Services;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

public class RPCommon {
    public static String[] nameSplit;
    public static List<ResourceLocation> dimResSplit;
    public static String[] itemSplit;
    public static AdvancementHolder[] advancements;
    private static HashMap<UUID, Long> sentMessage;

    public static void onServerStarting(MinecraftServer server) {
        String path = server.getWorldPath(LevelResource.DATAPACK_DIR).toString();
        AdvancementHelper.CreateDatapack(path);
        AdvancementHelper.ClearCustomAdvancements(path);
        nameSplit = Services.PLATFORM.getConfigDimensionsNames().split(",");
        dimResSplit = Arrays.stream(Services.PLATFORM.getConfigDimensionsResourceNames().split(",")).map(String::toLowerCase).map(ResourceLocation::parse).collect(Collectors.toList());
        itemSplit = Services.PLATFORM.getConfigCraftItems().split(",");
        advancements = new AdvancementHolder[nameSplit.length];
        for (int i = 0; i < nameSplit.length; ++i) {
            AdvancementHelper.AddCustomAdvancement(Services.PLATFORM.getConfigCraftedMessage().replace("%dim%", nameSplit[i]), Services.PLATFORM.getConfigDescription().replace("%dim%", nameSplit[i]).replace("%item%", Component.translatable((String)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemSplit[i]))).getDescriptionId()).getString()), itemSplit[i], nameSplit[i].toLowerCase().replace(" ", ""), path);
        }
        PackRepository resourcepacklist = server.getPackRepository();
        resourcepacklist.reload();
        ArrayList list = Lists.newArrayList((Iterable)resourcepacklist.getSelectedPacks());
        Pack restrictedPortalsDatapack = resourcepacklist.getPack("file/restrictedportals");
        if (!list.contains(restrictedPortalsDatapack)) {
            list.add(2, restrictedPortalsDatapack);
        }
        server.reloadResources((Collection)list.stream().map(Pack::getId).collect(Collectors.toList())).exceptionally(ex -> null);
        for (int i = 0; i < nameSplit.length; ++i) {
            RPCommon.advancements[i] = server.getAdvancements().get(ResourceLocation.parse((String)("restrictedportals:" + nameSplit[i].toLowerCase().replace(" ", ""))));
        }
    }

    public static boolean blockPlayerFromTransit(Entity player, ResourceKey<Level> dimension) {
        if (player instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)player;
            for (int i = 0; i < nameSplit.length; ++i) {
                if (dimension != ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimResSplit.get(i)) || playerMP.getAdvancements().getOrStartProgress(advancements[i]).isDone()) continue;
                if (!sentMessage.containsKey(playerMP.getUUID()) || playerMP.level().getGameTime() - sentMessage.get(playerMP.getUUID()) > 40L || playerMP.level().getGameTime() - sentMessage.get(playerMP.getUUID()) < 0L) {
                    String item = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemSplit[i]))).getDisplayName().getString();
                    if (!playerMP.level().isClientSide) {
                        playerMP.displayClientMessage((Component)Component.translatable((String)Services.PLATFORM.getConfigBlockedMessage().replace("%item%", item).replace("%dim%", nameSplit[i])), false);
                    }
                    sentMessage.put(playerMP.getUUID(), playerMP.level().getGameTime());
                }
                if (dimension == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"the_end")) && Services.PLATFORM.getConfigPreventEPDeath()) {
                    BlockPos coordinates = playerMP.getRespawnPosition();
                    if (coordinates == null) {
                        coordinates = playerMP.level().getSharedSpawnPos();
                    }
                    playerMP.setPos((double)coordinates.getX(), (double)coordinates.getY(), (double)coordinates.getZ());
                }
                return true;
            }
        }
        return false;
    }

    static {
        sentMessage = new HashMap();
    }
}

