/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.effect.OrbitingEffect;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.SoundHelper;

public class ElementalVortexEffect
extends OrbitingEffect {
    public LivingEntity sourceEntity;
    public int additionalData;

    public ElementalVortexEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType((ParticleOptions)ParticleTypes.CLOUD);
    }

    public void setSourcePlayer(LivingEntity livingEntity) {
        this.sourceEntity = livingEntity;
    }

    public void setAdditionalData(int data) {
        this.additionalData = data;
    }

    @Override
    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide()) {
            ServerLevel serverWorld = (ServerLevel)livingEntity.level();
            SoundHelper.loopSound(livingEntity, SoundRegistry.AMBIENCE_WIND_LOOP.getId(), 6, 20);
            MobEffectInstance mobEffectInstance = livingEntity.getEffect(EffectRegistry.getReference(EffectRegistry.ELEMENTAL_VORTEX));
            if (mobEffectInstance instanceof SimplySwordsStatusEffectInstance) {
                SimplySwordsStatusEffectInstance statusEffect = (SimplySwordsStatusEffectInstance)mobEffectInstance;
                this.sourceEntity = statusEffect.getSourceEntity();
                this.additionalData = statusEffect.getAdditionalData();
            }
            if (livingEntity.tickCount % 10 == 0) {
                AABB box = HelperMethods.createBox((Entity)livingEntity, 1 + amplifier / 6);
                for (Entity entity : serverWorld.getEntities((Entity)livingEntity, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, livingEntity) || this.additionalData == 0) continue;
                    DamageSource damageSource = livingEntity.damageSources().indirectMagic((Entity)livingEntity, (Entity)this.sourceEntity);
                    float spellScalingModifier = Config.uniqueEffects.tempest.spellScaling;
                    float abilityDamageFrost = HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "frost");
                    float abilityDamageFire = HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "fire");
                    le.invulnerableTime = 0;
                    le.hurt(damageSource, 3.0f + (float)amplifier / 2.0f + (abilityDamageFire + abilityDamageFrost));
                }
            }
            if (livingEntity.tickCount % 40 == 0) {
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position().add(0.0, (double)(livingEntity.getBbHeight() / 3.0f), 0.0), (ParticleOptions)ParticleTypes.LAVA, 0.5, 4);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position().add(0.0, (double)(livingEntity.getBbHeight() / 2.0f), 0.0), (ParticleOptions)ParticleTypes.SNOWFLAKE, 1.0, 6);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position().add(0.0, (double)(livingEntity.getBbHeight() / 2.0f), 0.0), (ParticleOptions)ParticleTypes.MYCELIUM, 1.5, 8);
            }
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    @Override
    public void removeAttributeModifiers(AttributeMap attributes) {
        LivingEntity entity = this.getEntityFromAttributeContainer(attributes);
        SoundHelper.stopLoopingSound(entity, SoundRegistry.AMBIENCE_WIND_LOOP.getId());
        super.removeAttributeModifiers(attributes);
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return super.shouldApplyEffectTickThisTick(pDuration, pAmplifier);
    }
}

