/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.entity.ThrownSwordEntity;
import net.sweenus.simplyswords.registry.ItemsRegistry;

public class ThrownRunicEntity
extends ThrownSwordEntity {
    public ThrownRunicEntity(EntityType<? extends ThrownRunicEntity> entityType, Level world) {
        super(entityType, world);
    }

    public ThrownRunicEntity(Level world, LivingEntity owner, ItemStack stack) {
        super(world, owner, stack);
        this.stack = stack;
    }

    @Override
    public void tick() {
        this.returnToPlayer = true;
        super.tick();
    }

    @Override
    public ItemStack getPickupItemStackOrigin() {
        return this.stack;
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ItemsRegistry.RUNIC_LONGSWORD.get());
    }

    @Override
    protected byte getLoyalty() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            return 3;
        }
        return 0;
    }
}

