/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.sweenus.simplyswords.registry.ItemsRegistry;

public enum ModToolMaterial implements Tier
{
    RUNIC(4, 2031, 9.0f, 5.0f, 25, Items.NETHERITE_INGOT),
    UNIQUE(4, 3270, 15.0f, 5.0f, 30, (Item)ItemsRegistry.RUNIC_TABLET.get()),
    GOBBER(5, 3800, 9.0f, 9.0f, 20, Items.DIAMOND),
    GOBBER_NETHER(6, 5200, 12.0f, 9.0f, 25, Items.DIAMOND),
    GOBBER_END(7, 8000, 14.0f, 9.0f, 30, Items.DIAMOND);

    private final int miningLevel;
    private final int itemDurability;
    private final float miningSpeed;
    private final float attackDamage;
    private final int enchantability;
    private final Supplier<Ingredient> repairIngredient;

    private ModToolMaterial(int miningLevel, int itemDurability, float miningSpeed, float attackDamage, int enchantability, Item ... repairIngredient) {
        this.miningLevel = miningLevel;
        this.itemDurability = itemDurability;
        this.miningSpeed = miningSpeed;
        this.attackDamage = attackDamage;
        this.enchantability = enchantability;
        this.repairIngredient = Suppliers.memoize(() -> Ingredient.of((ItemLike[])repairIngredient));
    }

    public int getUses() {
        return this.itemDurability;
    }

    public float getSpeed() {
        return this.miningSpeed;
    }

    public float getAttackDamageBonus() {
        return this.attackDamage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return null;
    }

    public int getEnchantmentValue() {
        return this.enchantability;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }
}

