/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.sweenus.simplyswords.client.api.SimplySwordsClientAPI;
import net.sweenus.simplyswords.util.HelperMethods;

public class SimplySwordsSwordItem
extends SwordItem {
    String[] repairIngredient;

    public SimplySwordsSwordItem(Tier toolMaterial, Item.Properties settings, String ... repairIngredient) {
        super(toolMaterial, settings);
        this.repairIngredient = repairIngredient;
    }

    public SimplySwordsSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
        this.repairIngredient = new String[0];
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        if (this.repairIngredient.length == 0) {
            return super.isValidRepairItem(stack, ingredient);
        }
        ArrayList potentialIngredients = new ArrayList(List.of());
        Arrays.stream(this.repairIngredient).toList().forEach(repIngredient -> potentialIngredients.add((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)repIngredient))));
        return potentialIngredients.contains(ingredient.getItem());
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        this.generateDynamicTooltip(itemStack, tooltipContext, tooltip, type);
    }

    protected void generateDynamicTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        SimplySwordsClientAPI.generateDynamicTooltip(itemStack, tooltipContext, tooltip, type, "simplyswords", "oracle_index:books/simplyswords/weapon-types", "oracle_index:books/simplyswords/unique-weapons", "oracle_index:books/simplyswords/runic-powers", null);
    }
}

