/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class ThunderbrandSwordItem
extends UniqueSwordItem
implements TwoHandedWeapon {
    private static final int ability_timer_max = 50;

    public ThunderbrandSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        HelperMethods.playHitSounds(attacker, target);
        if (!attacker.level().isClientSide()) {
            Player player;
            int chargeChance = Config.uniqueEffects.thunderbrand.chance;
            if (attacker.getRandom().nextInt(100) <= chargeChance && attacker instanceof Player && (player = (Player)attacker).getCooldowns().getCooldownPercent((Item)this, 1.0f) > 0.0f) {
                player.getCooldowns().addCooldown((Item)this, 0);
                attacker.level().playSound(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_BLOCK_01.get(), attacker.getSoundSource(), 0.7f, 1.0f);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_BOW_CHARGE_LONG_VERSION.get(), user.getSoundSource(), 0.4f, 0.6f);
        user.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 3), (Entity)user);
        user.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 40, 3), (Entity)user);
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.isClientSide && HelperMethods.isHolding(stack, user) && user.onGround()) {
            float abilityDamage = HelperMethods.spellScaledDamage("lightning", (Entity)user, Config.uniqueEffects.thunderbrand.spellScaling, Config.uniqueEffects.thunderbrand.damage);
            int skillCooldown = Config.uniqueEffects.thunderbrand.cooldown;
            int radius = Config.uniqueEffects.thunderbrand.radius;
            AbilityMethods.tickAbilityThunderBlitz(stack, world, user, remainingUseTicks, 50, abilityDamage, skillCooldown, radius);
        }
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.isClientSide && user.getItemBySlot(EquipmentSlot.MAINHAND) == stack) {
            user.setDeltaMovement(0.0, 0.0, 0.0);
            user.hurtMarked = true;
            user.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 80, 2), (Entity)user);
        }
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 50;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.MYCELIUM, (ParticleOptions)ParticleTypes.MYCELIUM, (ParticleOptions)ParticleTypes.MYCELIUM, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.thunderbrandsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.thunderbrandsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclickheld").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.thunderbrandsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.thunderbrandsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.thunderbrandsworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.thunderbrandsworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.thunderbrandsworditem.tooltip7").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "lightning");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedInt.Restrict(min=1)
        public int radius;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.THUNDERBRAND.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 15;
            this.cooldown = 250;
            this.damage = 3.0f;
            this.radius = 2;
            this.spellScaling = 1.7f;
        }
    }
}

