/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ItemLike;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.RecipeTypeRegistry;

public class RunicRerollRecipe
extends SmithingTransformRecipe {
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;
    final ItemStack result;

    public RunicRerollRecipe(Ingredient template, Ingredient base, Ingredient addition, ItemStack result) {
        super(template, base, addition, result);
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public ItemStack assemble(SmithingRecipeInput smithingRecipeInput, HolderLookup.Provider wrapperLookup) {
        ItemStack itemStack = smithingRecipeInput.base().transmuteCopy((ItemLike)this.result.getItem(), this.result.getCount());
        itemStack.applyComponents(this.result.getComponentsPatch());
        itemStack.remove((DataComponentType)ComponentTypeRegistry.GEM_POWER.get());
        return itemStack;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeTypeRegistry.REROLL.get();
    }

    public static class Serializer
    implements RecipeSerializer<RunicRerollRecipe> {
        private static final MapCodec<RunicRerollRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("template").forGetter(recipe -> recipe.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(recipe -> recipe.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter(recipe -> recipe.addition), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, RunicRerollRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RunicRerollRecipe> PACKET_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<RunicRerollRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RunicRerollRecipe> streamCodec() {
            return PACKET_CODEC;
        }

        private static RunicRerollRecipe read(RegistryFriendlyByteBuf buf) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            Ingredient ingredient2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            Ingredient ingredient3 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            return new RunicRerollRecipe(ingredient, ingredient2, ingredient3, itemStack);
        }

        private static void write(RegistryFriendlyByteBuf buf, RunicRerollRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.base);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.addition);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
        }
    }
}

