/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;

public interface Bannerable
extends Ability {
    public BannerPosition getBannerPosition();

    default public void tickBannerShip() {
        if (!this.self().getData(Ship.BANNER).isEmpty()) {
            this.self().prevBannerWaveAngle = this.self().bannerWaveAngle;
            this.self().bannerWaveAngle = (float)Math.sin(this.getBannerWaveSpeed() * (float)this.self().tickCount) * this.getBannerWaveFactor();
        }
    }

    default public void readBannerShipSaveData(CompoundTag tag) {
        Tag tag2 = tag.get("Banner");
        if (tag2 instanceof CompoundTag) {
            CompoundTag bannerCompound = (CompoundTag)tag2;
            this.self().setData(Ship.BANNER, ItemStack.parse((HolderLookup.Provider)this.self().registryAccess(), (Tag)bannerCompound).orElse(ItemStack.EMPTY));
        }
    }

    default public void addBannerShipSaveData(CompoundTag tag) {
        if (!this.self().getData(Ship.BANNER).isEmpty()) {
            tag.put("Banner", this.self().getData(Ship.BANNER).save((HolderLookup.Provider)this.self().registryAccess()));
        }
    }

    default public boolean interactBanner(Player player, InteractionHand interactionHand) {
        ItemStack item = player.getItemInHand(interactionHand);
        ItemStack shipBanner = this.self().getData(Ship.BANNER);
        shipBanner.setCount(1);
        if (item.getItem() instanceof BannerItem) {
            if (!shipBanner.isEmpty()) {
                this.self().spawnAtLocation(shipBanner, 4.0f);
            }
            this.self().setData(Ship.BANNER, item.copy());
            if (!player.isCreative()) {
                item.shrink(1);
            }
            this.self().level().playSound(player, this.self().getX(), this.self().getY() + 4.0, this.self().getZ(), SoundEvents.WOOL_HIT, this.self().getSoundSource(), 15.0f, 1.0f);
            return true;
        }
        if (item.getItem() instanceof ShearsItem && !shipBanner.isEmpty()) {
            this.self().spawnAtLocation(shipBanner, 4.0f);
            this.self().setData(Ship.BANNER, ItemStack.EMPTY);
            this.self().level().playSound(player, this.self().getX(), this.self().getY() + 4.0, this.self().getZ(), SoundEvents.WOOL_HIT, this.self().getSoundSource(), 15.0f, 1.0f);
            return true;
        }
        return false;
    }

    default public float getBannerWaveFactor() {
        return this.self().level().isRaining() ? 4.5f : 3.0f;
    }

    default public float getBannerWaveSpeed() {
        return this.self().level().isRaining() ? 0.55f : 0.25f;
    }

    default public float getBannerWaveAngle(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.self().prevBannerWaveAngle, (float)this.self().bannerWaveAngle);
    }

    public static class BannerPosition {
        public final float yp;
        public final float zp;
        public final double x;
        public final double y;
        public final double z;

        public BannerPosition(float yp, float zp, double x, double y, double z) {
            this.yp = yp;
            this.zp = zp;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

