/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterstructure_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.PlayerFunctions;
import com.natamus.starterstructure_common_neoforge.config.ConfigHandler;
import com.natamus.starterstructure_common_neoforge.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class StructureSpawnPointEvents {
    public static void onPlayerRespawn(ServerPlayer oldPlayer, ServerPlayer serverPlayer, boolean alive) {
        if (ConfigHandler.forceExactSpawn) {
            DimensionTransition optionalbed;
            ServerLevel serverLevel = (ServerLevel)serverPlayer.level();
            BlockPos respawnlocation = serverLevel.getSharedSpawnPos();
            Vec3 respawnvec = new Vec3((double)respawnlocation.getX() + 0.5, (double)respawnlocation.getY(), (double)respawnlocation.getZ() + 0.5);
            BlockPos bedpos = serverPlayer.getRespawnPosition();
            if (bedpos != null && !(optionalbed = serverPlayer.findRespawnPositionAndUseSpawnBlock(true, DimensionTransition.DO_NOTHING)).missingRespawnBlock()) {
                return;
            }
            serverPlayer.teleportTo(respawnvec.x, respawnvec.y, respawnvec.z);
        }
    }

    public static void onEntityJoin(Level level, Entity entity) {
        if (level.isClientSide) {
            return;
        }
        Util.processEntityMovementOnJoin(entity);
        if (!ConfigHandler.forceExactSpawn) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!PlayerFunctions.isJoiningWorldForTheFirstTime((Player)player, (String)"starterstructure", (boolean)false)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos ppos = player.blockPosition();
        BlockPos wspos = serverLevel.getSharedSpawnPos();
        if (new BlockPos(ppos.getX(), wspos.getY(), ppos.getZ()).closerThan((Vec3i)wspos, 50.0)) {
            player.teleportTo((double)wspos.getX() + 0.5, (double)wspos.getY(), (double)wspos.getZ() + 0.5);
        }
    }
}

