/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.GlobeRenderData;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeData;
import net.mehvahdjukaar.supplementaries.common.utils.Credits;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobeManager {
    private static final Map<String, TextureInstance> TEXTURE_CACHE = Maps.newHashMap();
    private static final HashMap<ResourceLocation, IntList> DIMENSION_COLORS = new HashMap();
    private static final IntList SEPIA_COLORS = new IntArrayList();
    private static final Map<String, GlobeRenderData> NAME_CACHE = new HashMap<String, GlobeRenderData>();
    private static final Map<String, Float> MODEL_ID_MAP = new HashMap<String, Float>();
    public static final List<ResourceLocation> TEXTURES = new ArrayList<ResourceLocation>();
    public static final GlobeRenderData DEFAULT_DATA = new GlobeRenderData(){

        @Override
        public Model getModel(boolean sepia) {
            return Model.GLOBE;
        }

        @Override
        @NotNull
        public ResourceLocation getTexture(boolean sepia) {
            if (!ClientConfigs.Blocks.GLOBE_RANDOM.get().booleanValue()) {
                return SpecialGlobe.EARTH.getTexture(sepia);
            }
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return ModTextures.GLOBE_EARTH_TEXTURE;
            }
            return GlobeManager.getTextureInstance((Level)level, (boolean)sepia).textureLocation;
        }
    };

    public static void refreshTextures() {
        TEXTURE_CACHE.clear();
    }

    private static TextureInstance getTextureInstance(Level world, boolean sepia) {
        return TEXTURE_CACHE.computeIfAbsent(GlobeManager.getTextureIdPerDimension(world, sepia), i -> new TextureInstance(world, sepia));
    }

    private static String getTextureIdPerDimension(Level level, boolean sepia) {
        Object id = level.dimension().location().getPath();
        if (sepia) {
            id = (String)id + "_sepia";
        }
        return id;
    }

    public static GlobeRenderData computeRenderData(boolean sheared, @Nullable Component customName) {
        GlobeRenderData specialGlobe;
        if (sheared) {
            return SpecialGlobe.SHEARED;
        }
        if (customName != null && (specialGlobe = NAME_CACHE.get(customName.getString().toLowerCase(Locale.ROOT))) != null) {
            return specialGlobe;
        }
        return DEFAULT_DATA;
    }

    public static Float getNamedGlobeTextureID(String text) {
        return Float.valueOf(Float.NEGATIVE_INFINITY);
    }

    public static void refreshColorsAndTextures(ResourceManager manager) {
        DIMENSION_COLORS.clear();
        int targetColors = 13;
        for (ResourceLocation res : manager.listResources("textures/entity/globes/palettes", r -> r.getPath().endsWith(".png")).keySet()) {
            List l = SpriteUtils.parsePaletteStrip((ResourceManager)manager, (ResourceLocation)res, (int)targetColors);
            String name = res.getPath();
            if ((name = name.substring(name.lastIndexOf("/") + 1).replace(".png", "")).equals("sepia")) {
                SEPIA_COLORS.clear();
                SEPIA_COLORS.addAll((Collection)l);
                continue;
            }
            DIMENSION_COLORS.put(ResourceLocation.tryParse((String)name.replace(".", ":")), (IntList)new IntArrayList((Collection)l));
        }
        if (DIMENSION_COLORS.isEmpty()) {
            Supplementaries.LOGGER.error("Could not find any globe palette in textures/entity/globes/palettes");
        }
        if (SEPIA_COLORS.isEmpty()) {
            throw new RuntimeException("Could not find sepia globe palette in textures/entity/globes/palettes");
        }
        GlobeManager.recomputeCache();
        GlobeManager.refreshTextures();
    }

    private static void recomputeCache() {
        NAME_CACHE.clear();
        for (SpecialGlobe type : SpecialGlobe.values()) {
            if (type.keyWords.length == 0) continue;
            if (type.transKeyWord != null && !type.transKeyWord.getString().isEmpty()) {
                NAME_CACHE.put(type.transKeyWord.getString().toLowerCase(Locale.ROOT), type);
            }
            for (String s : type.keyWords) {
                if (s.isEmpty()) continue;
                NAME_CACHE.put(s, type);
            }
        }
        for (Map.Entry entry : Credits.INSTANCE.globes().entrySet()) {
            ResourceLocation path = (ResourceLocation)entry.getValue();
            Model model = Model.GLOBE;
            if (path.getPath().contains("globe_wais")) {
                model = Model.SNOW;
            }
            NAME_CACHE.put((String)entry.getKey(), SimpleData.of(model, path));
        }
        TEXTURES.clear();
        HashSet allTextures = new HashSet();
        NAME_CACHE.values().forEach(o -> {
            if (o == DEFAULT_DATA || o == SpecialGlobe.ROUND) {
                return;
            }
            ResourceLocation t1 = o.getTexture(false);
            allTextures.add(t1);
            ResourceLocation t2 = o.getTexture(true);
            if (t1 != t2) {
                allTextures.add(t2);
            }
        });
        TEXTURES.addAll(allTextures);
    }

    private static class TextureInstance
    implements AutoCloseable {
        private final ResourceLocation textureLocation;
        private final DynamicTexture texture;
        private final ResourceLocation dimensionId;
        private final boolean sepiaColored;

        private TextureInstance(Level world, boolean sepia) {
            this.sepiaColored = sepia;
            this.dimensionId = world.dimension().location();
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)true);
            this.texture = new DynamicTexture(32, 16, false);
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)false);
            this.updateTexture(world);
            this.textureLocation = Minecraft.getInstance().getTextureManager().register("globe/" + this.dimensionId.toString().replace(":", "_"), this.texture);
        }

        private void updateTexture(Level world) {
            GlobeData data = (GlobeData)ModRegistry.GLOBE_DATA.getData(world);
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.texture.getPixels().setPixelRGBA(j, i, -13061505);
                }
            }
            int width = data.getTextureWidth();
            int height = data.getTextureHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.texture.getPixels().setPixelRGBA(x, y, TextureInstance.getRGBA(data.getPixel(x, y), this.dimensionId, this.sepiaColored));
                }
            }
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)true);
            this.texture.upload();
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)false);
        }

        @Override
        public void close() {
            this.texture.close();
            Minecraft.getInstance().getTextureManager().release(this.textureLocation);
        }

        private static int getRGBA(byte b, ResourceLocation dimension, boolean sepia) {
            if (sepia) {
                return SEPIA_COLORS.getInt((int)b);
            }
            IntList l = DIMENSION_COLORS.getOrDefault(dimension, DIMENSION_COLORS.get(ResourceLocation.withDefaultNamespace((String)"overworld")));
            if (l != null) {
                return l.getInt((int)b);
            }
            return 1;
        }
    }

    private static enum SpecialGlobe implements GlobeRenderData
    {
        FLAT((Component)Component.translatable((String)"globe.supplementaries.flat"), ModTextures.GLOBE_FLAT_TEXTURE, ModTextures.GLOBE_FLAT_TEXTURE_SEPIA, Model.FLAT, "flat", "flat earth"),
        MOON((Component)Component.translatable((String)"globe.supplementaries.moon"), ModTextures.GLOBE_MOON_TEXTURE, ModTextures.GLOBE_MOON_TEXTURE, "moon", "luna", "selene", "cynthia"),
        EARTH((Component)Component.translatable((String)"globe.supplementaries.earth"), ModTextures.GLOBE_EARTH_TEXTURE, ModTextures.GLOBE_EARTH_TEXTURE_SEPIA, "earth", "terra", "gaia", "gaea", "tierra", "tellus", "terre"),
        SUN((Component)Component.translatable((String)"globe.supplementaries.sun"), ModTextures.GLOBE_SUN_TEXTURE, ModTextures.GLOBE_SUN_TEXTURE, "sun", "sol", "helios"),
        SHEARED((Component)Component.literal((String)"sheared"), ModTextures.GLOBE_SHEARED_TEXTURE, ModTextures.GLOBE_SHEARED_SEPIA_TEXTURE, Model.SHEARED, new String[0]),
        ROUND((Component)Component.translatable((String)"globe.supplementaries.round"), ModTextures.GLOBE_EARTH_TEXTURE, ModTextures.GLOBE_EARTH_TEXTURE_SEPIA, Model.ROUND, "round", "sphere", "spherical");

        private final String[] keyWords;
        private final Component transKeyWord;
        private final ResourceLocation texture;
        private final ResourceLocation textureSepia;
        private final Model model;

        private SpecialGlobe(Component tr, ResourceLocation texture, ResourceLocation textureSepia, String ... key) {
            this(tr, texture, textureSepia, Model.GLOBE, key);
        }

        private SpecialGlobe(Component tr, ResourceLocation texture, ResourceLocation textureSepia, Model model, String ... keywords) {
            this.keyWords = keywords;
            this.transKeyWord = tr;
            this.texture = texture;
            this.textureSepia = textureSepia;
            this.model = model;
        }

        @Override
        @NotNull
        public ResourceLocation getTexture(boolean sepia) {
            if (this == ROUND) {
                return DEFAULT_DATA.getTexture(sepia);
            }
            return sepia ? this.textureSepia : this.texture;
        }

        @Override
        public Model getModel(boolean sepia) {
            return this.model;
        }
    }

    public static enum Model {
        GLOBE,
        FLAT,
        SNOW,
        SHEARED,
        ROUND;

    }

    private record SimpleData(Model model, @NotNull ResourceLocation texture) implements GlobeRenderData
    {
        public static SimpleData of(Model model, @NotNull ResourceLocation texture) {
            return new SimpleData(model, texture);
        }

        @Override
        public Model getModel(boolean sepia) {
            return this.model;
        }

        @Override
        @NotNull
        public ResourceLocation getTexture(boolean sepia) {
            return this.texture;
        }
    }
}

