/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public interface ILavaAndWaterLoggable
extends BucketPickup,
LiquidBlockContainer {
    default public boolean canPlaceLiquid(@Nullable Player player, BlockGetter reader, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)ModBlockProperties.LAVALOGGED) == false && fluid == Fluids.LAVA || (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && fluid == Fluids.WATER;
    }

    default public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)ModBlockProperties.LAVALOGGED)).booleanValue() && fluidState.getType() == Fluids.LAVA) {
            if (!world.isClientSide()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)ModBlockProperties.LAVALOGGED, (Comparable)Boolean.TRUE), 3);
                world.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)world));
            }
            return true;
        }
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            if (!world.isClientSide()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.TRUE), 3);
                world.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)world));
            }
            return true;
        }
        return false;
    }

    default public ItemStack pickupBlock(@Nullable Player player, LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        if (((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE), 3);
            if (!pState.canSurvive((LevelReader)pLevel, pPos)) {
                pLevel.destroyBlock(pPos, true);
            }
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        if (((Boolean)pState.getValue((Property)ModBlockProperties.LAVALOGGED)).booleanValue()) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)ModBlockProperties.LAVALOGGED, (Comparable)Boolean.FALSE), 3);
            if (!pState.canSurvive((LevelReader)pLevel, pPos)) {
                pLevel.destroyBlock(pPos, true);
            }
            return new ItemStack((ItemLike)Items.LAVA_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    default public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }
}

