/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.serialization.MapCodec;
import java.util.function.BiFunction;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConfettiLitterBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<ConfettiLitterBlock> CODEC = ConfettiLitterBlock.simpleCodec(ConfettiLitterBlock::new);
    public static final IntegerProperty AMOUNT = ModBlockProperties.CONFETTI_AMOUNT;
    private static final BiFunction<Direction, Integer, VoxelShape> SHAPE_BY_PROPERTIES = Util.memoize((direction, integer) -> {
        VoxelShape[] voxelShapes = new VoxelShape[]{Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)8.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)8.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)3.0, (double)16.0)};
        VoxelShape voxelShape = Shapes.empty();
        for (int i = 0; i < integer; ++i) {
            int j = Math.floorMod(i - direction.get2DDataValue(), 4);
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)voxelShapes[j]);
        }
        return voxelShape.singleEncompassing();
    });

    public ConfettiLitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)AMOUNT) < 4 || super.canBeReplaced(state, useContext);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_PROPERTIES.apply((Direction)state.getValue((Property)FACING), (Integer)state.getValue((Property)AMOUNT));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        return blockState.is((Block)this) ? (BlockState)blockState.setValue((Property)AMOUNT, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockState.getValue((Property)AMOUNT) + 1))) : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AMOUNT});
    }
}

