/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public record ServerBoundSetPresentPacket(BlockPos pos, boolean packed, String recipient, String sender, String description) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundSetPresentPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("c2s_set_present"), ServerBoundSetPresentPacket::new);

    public ServerBoundSetPresentPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readBoolean(), buf.readUtf(), buf.readUtf(), buf.readUtf());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.packed);
        buf.writeUtf(this.recipient);
        buf.writeUtf(this.sender);
        buf.writeUtf(this.description);
    }

    public void handle(Message.Context context) {
        BlockEntity blockEntity;
        ServerPlayer player;
        Level level;
        Player player2 = context.getPlayer();
        if (player2 instanceof ServerPlayer && (level = (player = (ServerPlayer)player2).level()).hasChunkAt(this.pos) && (blockEntity = level.getBlockEntity(this.pos)) instanceof PresentBlockTile) {
            PresentBlockTile present = (PresentBlockTile)blockEntity;
            present.updateState(this.packed, this.recipient, this.sender, this.description, (Player)player);
            BlockState state = level.getBlockState(this.pos);
            present.setChanged();
            level.sendBlockUpdated(this.pos, state, state, 3);
            if (this.packed) {
                player.doCloseContainer();
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

