/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station;

import com.mojang.datafixers.util.Either;
import com.oierbravo.trading_station.content.trading_recipe.TradingRecipe;
import com.oierbravo.trading_station.content.trading_station.TargetedRecipeUtils;
import com.oierbravo.trading_station.foundation.gui.TradingRecipeTooltipComponent;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;

@Mod(value="trading_station", dist={Dist.CLIENT})
@EventBusSubscriber
public class TradingStationClient {
    public TradingStationClient(IEventBus modEventBus) {
        TradingStationClient.onCtorClient(modEventBus);
    }

    public static void onCtorClient(IEventBus modEventBus) {
        modEventBus.addListener(TradingStationClient::onRegisterClientTooltipEvent);
    }

    private static void onRegisterClientTooltipEvent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(TradingRecipeTooltipComponent.class, Function.identity());
    }

    @SubscribeEvent
    public static void gatherTooltips(RenderTooltipEvent.GatherComponents event) {
        Optional<RecipeHolder<?>> recipeHolder = TargetedRecipeUtils.getRecipeFromItemStack(event.getItemStack());
        if (recipeHolder.isEmpty()) {
            return;
        }
        TradingRecipe recipe = (TradingRecipe)recipeHolder.get().value();
        event.getTooltipElements().add(Either.right((Object)new TradingRecipeTooltipComponent(recipe)));
    }
}

