/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.compat.jei;

import com.oierbravo.mechanicals.compat.jei.RecipeRequirementRenderer;
import com.oierbravo.mechanicals.foundation.gui.MechanicalGUITextures;
import com.oierbravo.mechanicals.foundation.ingredient.CountableIngredient;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeWithRequirements;
import com.oierbravo.trading_station.ModLang;
import com.oierbravo.trading_station.compat.jei.TradingStationJEIPlugin;
import com.oierbravo.trading_station.content.trading_recipe.TradingRecipe;
import com.oierbravo.trading_station.registrate.ModBlocks;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class TradingRecipeCategory
implements IRecipeCategory<TradingRecipe> {
    private final IDrawable background = new IDrawable(this){

        public int getWidth() {
            return 176;
        }

        public int getHeight() {
            return 51;
        }

        public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
        }
    };
    private final IDrawable icon;

    @Nullable
    public ResourceLocation getRegistryName(TradingRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)TradingRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((Object)((Object)((TradingRecipe)recipeHolder.value()))).equals((Object)recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public TradingRecipeCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.TRADING_STATION.get()));
    }

    public RecipeType<TradingRecipe> getRecipeType() {
        return TradingStationJEIPlugin.TRADING_RECIPE;
    }

    public Component getTitle() {
        return ModLang.translate("trading.recipe", new Object[0]).component();
    }

    public int getWidth() {
        return 180;
    }

    public int getHeight() {
        return 70;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull TradingRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        NonNullList<CountableIngredient> ingredients = recipe.getCountableIngredients();
        for (int index = 0; index < ingredients.size(); ++index) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0 + index * 18, 0).addItemStack(((CountableIngredient)ingredients.get(index)).asItemStack())).setStandardSlotBackground().setSlotName("input_" + index);
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 35, 23).addItemStack(recipe.getResult())).setStandardSlotBackground().setSlotName("output");
    }

    public void draw(TradingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, graphics, mouseX, mouseY);
        this.drawRequirements(graphics, recipe, 60, 2);
        this.drawProcessingTime(recipe, graphics, 16, 38);
        MechanicalGUITextures.JEI_DOWN_RIGHT_ARROW.render(graphics, 16, 23);
    }

    private void drawRequirements(GuiGraphics pGuiGraphics, TradingRecipe recipe, int pX, int pY) {
        RecipeRequirementRenderer.drawRequirements((IRecipeWithRequirements)recipe, (GuiGraphics)pGuiGraphics, (int)pX, (int)pY);
    }

    protected void drawProcessingTime(TradingRecipe recipe, GuiGraphics graphics, int x, int y) {
        int processingTime = recipe.getProcessingTime();
        if (processingTime > 0) {
            int cookTimeSeconds = processingTime / 20;
            MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font fontRenderer = minecraft.font;
            graphics.drawString(fontRenderer, (Component)timeString, x, y, -8355712, false);
        }
    }
}

