/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.content.trading_recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.oierbravo.mechanicals.foundation.recipe.RecipeRequirementType;
import com.oierbravo.trading_station.ModLang;
import com.oierbravo.trading_station.content.trading_recipe.IHaveMachineId;
import com.oierbravo.trading_station.registrate.ModRecipeRequirementTypes;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record MachineRequirement(List<String> machineId) implements IRecipeRequirement
{
    public static String ID = "machine_id";
    public static MapCodec<MachineRequirement> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.listOf().optionalFieldOf("value", List.of()).forGetter(MachineRequirement::machineId)).apply((Applicative)builder, MachineRequirement::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MachineRequirement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list((int)16)), MachineRequirement::machineId, MachineRequirement::new);

    public RecipeRequirementType<?> getType() {
        return ModRecipeRequirementTypes.MACHINE_ID.get();
    }

    public boolean test(Level level, BlockEntity blockEntity) {
        if (this.machineId.isEmpty()) {
            return true;
        }
        if (blockEntity instanceof IHaveMachineId) {
            for (String id : this.machineId) {
                if (!id.equals(((IHaveMachineId)blockEntity).getMachineId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.machineId.isEmpty()) {
            return ModLang.translate("ui.recipe_requirement.machine_id.any", new Object[0]).toString();
        }
        return String.join((CharSequence)",", this.machineId);
    }

    public String getIdString() {
        return ID;
    }

    public static MachineRequirement of(String ... machineId) {
        return new MachineRequirement(List.of(machineId));
    }
}

