/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.content.trading_recipe;

import com.oierbravo.mechanicals.foundation.ingredient.CountableIngredient;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipe;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipeParams;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.oierbravo.trading_station.content.trading_recipe.TradingRecipeSerializer;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class TradingRecipe
extends AbstractMechanicalRecipe<RecipeInput, TradingRecipeParams> {
    private final NonNullList<CountableIngredient> itemIngredients;
    private final ItemStack result;
    private final int processingTime;

    public TradingRecipe(TradingRecipeParams params) {
        super((AbstractMechanicalRecipeParams)params);
        this.result = params.result;
        this.itemIngredients = params.itemIngredients;
        this.processingTime = params.processingTime;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList outputIngredients = NonNullList.create();
        this.itemIngredients.forEach(countableIngredient -> outputIngredients.add((Object)countableIngredient.ingredient()));
        return outputIngredients;
    }

    public NonNullList<CountableIngredient> getCountableIngredients() {
        return this.itemIngredients;
    }

    public RecipeSerializer<?> getSerializer() {
        return TradingRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean matches(RecipeInput pRecipeInput, Level pLevel) {
        if (pLevel.isClientSide) {
            return false;
        }
        if (pRecipeInput.size() != this.itemIngredients.size()) {
            return false;
        }
        int matchedIngredients = 0;
        for (int i = 0; i < this.itemIngredients.size(); ++i) {
            CountableIngredient ingredient = (CountableIngredient)this.itemIngredients.get(i);
            for (int slot = 0; slot < pRecipeInput.size(); ++slot) {
                ItemStack itemStack = pRecipeInput.getItem(slot);
                if (!ingredient.test(pRecipeInput.getItem(slot))) continue;
                ++matchedIngredients;
            }
        }
        return matchedIngredients == this.itemIngredients.size();
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return null;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public boolean matchIngredient(int slot, ItemStack stack) {
        if (this.getIngredients().size() - 1 < slot) {
            return false;
        }
        return ((Ingredient)this.getIngredients().get(slot)).test(stack);
    }

    public ArrayList<IRecipeRequirement> getRecipeRequirements() {
        return this.recipeRequirements;
    }

    public static class TradingRecipeParams
    extends AbstractMechanicalRecipeParams {
        protected NonNullList<CountableIngredient> itemIngredients = NonNullList.create();
        protected ItemStack result = ItemStack.EMPTY;
        protected int processingTime = 1;

        protected TradingRecipeParams() {
        }
    }

    public static class Type
    implements RecipeType<TradingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final RecipeType<TradingRecipe> RECIPE_TYPE = new Type();
        public static final String ID = "trading";

        private Type() {
        }
    }
}

