/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.content.trading_recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.oierbravo.mechanicals.foundation.ingredient.CountableIngredient;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipe;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.oierbravo.trading_station.content.trading_recipe.TradingRecipe;
import com.oierbravo.trading_station.content.trading_recipe.TradingRecipeBuilder;
import java.util.List;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class TradingRecipeSerializer
implements RecipeSerializer<TradingRecipe> {
    public static final TradingRecipeSerializer INSTANCE = new TradingRecipeSerializer();
    public final StreamCodec<RegistryFriendlyByteBuf, TradingRecipe> STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);
    public static final MapCodec<TradingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NonNullList.codecOf((Codec)CountableIngredient.CODEC).fieldOf("ingredients").forGetter(TradingRecipe::getCountableIngredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(TradingRecipe::getResult), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("processingTime", (Object)0).forGetter(TradingRecipe::getProcessingTime), (App)IRecipeRequirement.LIST_CODEC.optionalFieldOf("requirements", List.of()).forGetter(TradingRecipe::getRecipeRequirements), (App)ICondition.LIST_CODEC.optionalFieldOf("neoforge:conditions", List.of()).forGetter(AbstractMechanicalRecipe::getConditions)).apply((Applicative)instance, (input, result, processingTime, requirements, iConditions) -> ((TradingRecipeBuilder)((TradingRecipeBuilder)new TradingRecipeBuilder().require((NonNullList<CountableIngredient>)input).output((ItemStack)result).processingTime((int)processingTime).withRequirements((List)requirements)).withConditions((List)iConditions)).build()));
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"trading_station", (String)"trading");

    private TradingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        NonNullList input = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)CountableIngredient.STREAM_CODEC).decode((Object)buffer);
        ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        int processingTime = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer);
        List recipeRequirements = (List)IRecipeRequirement.LIST_STREAM_CODEC.decode((Object)buffer);
        return ((TradingRecipeBuilder)new TradingRecipeBuilder().require((NonNullList<CountableIngredient>)input).output(output).processingTime(processingTime).withRequirements(recipeRequirements)).build();
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, TradingRecipe tradingRecipe) {
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)CountableIngredient.STREAM_CODEC).encode((Object)buffer, tradingRecipe.getCountableIngredients());
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)tradingRecipe.getResult());
        ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)tradingRecipe.getProcessingTime());
        IRecipeRequirement.LIST_STREAM_CODEC.encode((Object)buffer, tradingRecipe.getRecipeRequirements());
    }

    @NotNull
    public MapCodec<TradingRecipe> codec() {
        return CODEC;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, TradingRecipe> streamCodec() {
        return this.STREAM_CODEC;
    }
}

