/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.content.trading_station;

import com.oierbravo.mechanicals.compat.jade.IHavePercent;
import com.oierbravo.mechanicals.foundation.ingredient.CountableIngredient;
import com.oierbravo.trading_station.content.trading_recipe.TradingRecipe;
import com.oierbravo.trading_station.content.trading_station.TargetedRecipeUtils;
import com.oierbravo.trading_station.foundation.component.TradingRecipeComponent;
import com.oierbravo.trading_station.foundation.util.TradingUtils;
import com.oierbravo.trading_station.network.packets.data.ItemSyncPayload;
import com.oierbravo.trading_station.registrate.ModItemComponents;
import com.oierbravo.trading_station.registrate.ModRecipes;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public interface ITradingStationBlockEntity
extends IHavePercent {
    public static final int DEFAULT_PROCESSING_TIME = 500;

    public ItemStackHandler getInputItemHandler();

    public ItemStackHandler getOutputItemHandler();

    public ItemStackHandler getTargetItemHandler();

    default public void setItemStack(int slot, ItemStack itemStack, ItemSyncPayload.SlotType slotType) {
        if (slotType == ItemSyncPayload.SlotType.INPUT) {
            this.getInputItemHandler().setStackInSlot(slot, itemStack);
        } else if (slotType == ItemSyncPayload.SlotType.OUTPUT) {
            this.getOutputItemHandler().setStackInSlot(slot, itemStack);
        } else if (slotType == ItemSyncPayload.SlotType.TARGET) {
            this.getTargetItemHandler().setStackInSlot(slot, itemStack);
        }
    }

    default public IEnergyStorage getEnergyStorageHandler() {
        return null;
    }

    default public String getTargetedRecipeId() {
        Optional<RecipeHolder<?>> recipeHolder = TargetedRecipeUtils.getRecipeFromItemStack(this.getTargetItemHandler().getStackInSlot(0));
        return recipeHolder.map(holder -> holder.id().toString()).orElse("");
    }

    default public void setTargetedRecipeById(ResourceLocation recipeId) {
        Optional<RecipeHolder<?>> recipeHolder = ModRecipes.findById(this.getLevel(), recipeId);
        if (recipeHolder.isPresent()) {
            TradingRecipe recipe = (TradingRecipe)recipeHolder.get().value();
            ItemStack targetedItemStack = recipe.getResult();
            targetedItemStack.set(ModItemComponents.TRADING_RECIPE_ID, (Object)new TradingRecipeComponent(recipeHolder.get().id()));
            this.getTargetItemHandler().setStackInSlot(0, targetedItemStack);
            this.setChangedInternal();
        }
    }

    default public Optional<RecipeHolder<?>> getRecipe() {
        ItemStack targetedItemStack = this.getTargetItemHandler().getStackInSlot(0);
        if (targetedItemStack.isEmpty()) {
            return Optional.empty();
        }
        return TargetedRecipeUtils.getRecipeFromItemStack(targetedItemStack);
    }

    default public boolean canCraftItem() {
        ItemStackHandler inputInventory = this.getInputItemHandler();
        Optional<RecipeHolder<?>> match = this.getRecipe();
        if (match.isEmpty()) {
            this.resetProgress();
            return false;
        }
        TradingRecipe tradingRecipe = (TradingRecipe)match.get().value();
        ArrayList<ItemStack> currentStackList = new ArrayList<ItemStack>();
        for (int i = 0; i < 2; ++i) {
            ItemStack currentStack = inputInventory.getStackInSlot(i);
            if (currentStack.isEmpty()) continue;
            currentStackList.add(currentStack);
        }
        if (tradingRecipe.getIngredients().size() != currentStackList.size()) {
            this.resetProgress();
            return false;
        }
        return this.hasEnoughInputItems((IItemHandler)inputInventory, tradingRecipe.getCountableIngredients()) && this.hasEnoughOutputSpace(this.getOutputItemHandler(), tradingRecipe.getResult());
    }

    public byte getRedstoneMode();

    public void setInputLock(boolean var1);

    public boolean isLocked();

    public void readClient(CompoundTag var1, HolderLookup.Provider var2);

    public BlockPos getBlockPos();

    public Level getLevel();

    public void setWorking(boolean var1);

    public boolean isWorking();

    public boolean canProcess(ItemStack var1);

    public void resetProgress();

    default public int getProcessingTime() {
        if (this.getRecipe().isEmpty()) {
            return 500;
        }
        return ((TradingRecipe)this.getRecipe().get().value()).getProcessingTime();
    }

    default public int getProgressPercent() {
        return this.getProgress() * 100 / this.getMaxProgress();
    }

    public int getProgress();

    public int getMaxProgress();

    default public void craftItem() {
        Optional<RecipeHolder<?>> recipeHolder = this.getRecipe();
        ItemStack resultItemStack = ItemStack.EMPTY;
        if (recipeHolder.isPresent()) {
            TradingRecipe recipe = (TradingRecipe)recipeHolder.get().value();
            for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                CountableIngredient ingredient = (CountableIngredient)recipe.getCountableIngredients().get(i);
                for (int slot = 0; slot < this.getInputItemHandler().getSlots(); ++slot) {
                    ItemStack itemStack = this.getInputItemHandler().getStackInSlot(slot);
                    if (!ingredient.test(itemStack)) continue;
                    this.getInputItemHandler().extractItem(slot, ingredient.count(), false);
                }
            }
            resultItemStack = TradingUtils.reEnchantItemStack(recipe.getResult(), this.getLevel());
            this.getOutputItemHandler().insertItem(0, resultItemStack, false);
        }
        this.resetProgress();
        this.craftCompleted(resultItemStack);
    }

    default public void craftCompleted(ItemStack resulItemStack) {
    }

    public void setRedstoneMode(byte var1);

    public byte getCurrentRedstoneMode();

    public void sendToMenu(RegistryFriendlyByteBuf var1);

    default public void clearTargetedRecipe() {
        this.getTargetItemHandler().setStackInSlot(0, ItemStack.EMPTY);
        this.setChangedInternal();
    }

    public void setChangedInternal();

    default public boolean hasEnoughInputItems(IItemHandler inventory, NonNullList<CountableIngredient> ingredients) {
        int enough = 0;
        for (int ingredientIndex = 0; ingredientIndex < ingredients.size(); ++ingredientIndex) {
            CountableIngredient ingredient = (CountableIngredient)ingredients.get(ingredientIndex);
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                if (!ingredient.test(inventory.getStackInSlot(slot)) || inventory.getStackInSlot(slot).getCount() < ingredient.count()) continue;
                ++enough;
            }
        }
        return ingredients.size() == enough;
    }

    default public boolean isPowered() {
        if (this.getCurrentRedstoneMode() == REDSTONE_MODES.IGNORE.ordinal()) {
            return true;
        }
        if (this.getCurrentRedstoneMode() == REDSTONE_MODES.LOW.ordinal()) {
            return (Boolean)this.getLevel().getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.POWERED) == false;
        }
        return (Boolean)this.getLevel().getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.POWERED);
    }

    default public boolean hasEnoughOutputSpace(ItemStackHandler stackHandler, ItemStack resultItemStack) {
        return stackHandler.getStackInSlot(0).isEmpty() || stackHandler.getStackInSlot(0).is(resultItemStack.getItem()) && stackHandler.getStackInSlot(0).getMaxStackSize() - stackHandler.getStackInSlot(0).getCount() >= resultItemStack.getCount();
    }

    default public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.getInputItemHandler().getSlots() + 1);
        for (int i = 0; i < this.getInputItemHandler().getSlots(); ++i) {
            inventory.setItem(i, this.getInputItemHandler().getStackInSlot(i));
        }
        inventory.setItem(this.getInputItemHandler().getSlots(), this.getInputItemHandler().getStackInSlot(0));
        Containers.dropContents((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (Container)inventory);
    }

    public static enum REDSTONE_MODES {
        IGNORE,
        LOW,
        HIGH;

    }
}

