/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.content.trading_station;

import com.oierbravo.trading_station.content.trading_recipe.IHaveMachineId;
import com.oierbravo.trading_station.content.trading_recipe.TradingRecipe;
import com.oierbravo.trading_station.content.trading_station.ITradingStationBlockEntity;
import com.oierbravo.trading_station.content.trading_station.TradingStationBlock;
import com.oierbravo.trading_station.content.trading_station.TradingStationMenu;
import com.oierbravo.trading_station.infrastructure.config.MConfigs;
import com.oierbravo.trading_station.registrate.ModBlockEntities;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradingStationBlockEntity
extends BlockEntity
implements MenuProvider,
ITradingStationBlockEntity,
IHaveMachineId {
    private CompoundTag updateTag;
    public final ItemStackHandler inputItems = this.createInputItemHandler();
    public final ItemStackHandler outputItems = this.createOutputItemHandler();
    public final ItemStackHandler targetItemHandler = this.createTargetItemHandler();
    private final Lazy<IItemHandler> inputItemHandler = Lazy.of(() -> this.inputItems);
    private final Lazy<IItemHandler> outputItemHandler = Lazy.of(() -> this.outputItems);
    public int progress = 0;
    public int maxProgress = 1;
    private boolean isWorking = false;
    protected final ContainerData containerData;
    byte currentRedstoneMode = 0;
    protected boolean inputLocked = false;

    public TradingStationBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
        this.updateTag = this.getPersistentData();
        this.containerData = this.createContainerData();
    }

    public ContainerData createContainerData() {
        return new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> TradingStationBlockEntity.this.progress;
                    case 1 -> TradingStationBlockEntity.this.maxProgress;
                    case 2 -> TradingStationBlockEntity.this.currentRedstoneMode;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        TradingStationBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        TradingStationBlockEntity.this.maxProgress = pValue;
                        break;
                    }
                    case 2: {
                        TradingStationBlockEntity.this.currentRedstoneMode = (byte)pValue;
                    }
                }
            }

            public int getCount() {
                return 3;
            }
        };
    }

    @Nonnull
    @NotNull
    private ItemStackHandler createTargetItemHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                TradingStationBlockEntity.this.setChanged();
                TradingStationBlockEntity.this.resetProgress();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return true;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return ItemStack.EMPTY;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.EMPTY;
            }
        };
    }

    private ItemStackHandler createInputItemHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                TradingStationBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (!TradingStationBlockEntity.this.isLocked()) {
                    return true;
                }
                Optional recipe = TradingStationBlockEntity.this.getRecipe();
                if (recipe.isEmpty()) {
                    return true;
                }
                return ((TradingRecipe)((RecipeHolder)recipe.get()).value()).matchIngredient(slot, stack);
            }
        };
    }

    @Nonnull
    @NotNull
    private ItemStackHandler createOutputItemHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, ItemStack stack) {
                return TradingStationBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
            }
        };
    }

    public void setRemoved() {
        super.setRemoved();
        this.inputItemHandler.invalidate();
        this.outputItemHandler.invalidate();
    }

    @Override
    public ItemStackHandler getInputItemHandler() {
        return this.inputItems;
    }

    @Override
    public ItemStackHandler getOutputItemHandler() {
        return this.outputItems;
    }

    @Override
    public ItemStackHandler getTargetItemHandler() {
        return this.targetItemHandler;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.TRADING_STATION_BLOCK_ENTITY.get(), (be, context) -> {
            Direction localDir = (Direction)be.getBlockState().getValue((Property)TradingStationBlock.HORIZONTAL_FACING);
            if (context != null && localDir == context.getOpposite()) {
                return be.getInputItemHandler();
            }
            if (context == Direction.DOWN) {
                return be.getOutputItemHandler();
            }
            if (context != null && localDir == context.getClockWise()) {
                return be.getOutputItemHandler();
            }
            if (context != null && localDir == context.getCounterClockWise()) {
                return be.getInputItemHandler();
            }
            if (context == null) {
                return null;
            }
            return null;
        });
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("input", (Tag)this.inputItems.serializeNBT(registries));
        tag.put("output", (Tag)this.outputItems.serializeNBT(registries));
        tag.put("target", (Tag)this.targetItemHandler.serializeNBT(registries));
        tag.putInt("progress", this.progress);
        tag.putInt("maxProgress", this.maxProgress);
        tag.putByte("redstoneMode", this.currentRedstoneMode);
        tag.putBoolean("isWorking", this.isWorking);
        tag.putBoolean("inputLocked", this.inputLocked);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inputItems.deserializeNBT(registries, tag.getCompound("input"));
        this.outputItems.deserializeNBT(registries, tag.getCompound("output"));
        this.targetItemHandler.deserializeNBT(registries, tag.getCompound("target"));
        this.progress = tag.getInt("progress");
        this.maxProgress = tag.getInt("maxProgress");
        this.currentRedstoneMode = tag.getByte("redstoneMode");
        this.isWorking = tag.getBoolean("isWorking");
        this.inputLocked = tag.getBoolean("inputLocked");
    }

    @Override
    public void resetProgress() {
        this.progress = 0;
        this.maxProgress = 1;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide()) {
            return;
        }
        if (!this.isPowered()) {
            this.setWorking(false);
            return;
        }
        if (!this.canCraftItem()) {
            this.setWorking(false);
            return;
        }
        this.updateProgress();
        this.maxProgress = this.getProcessingTime();
        if (this.progress > this.maxProgress) {
            this.craftItem();
        }
        this.setWorking(true);
    }

    @Override
    public void setWorking(boolean value) {
        this.isWorking = value;
        BlockState pState = (BlockState)this.getBlockState().setValue((Property)TradingStationBlock.LIT, (Comparable)Boolean.valueOf(this.isWorking()));
        this.getLevel().setBlock(this.getBlockPos(), pState, 2);
        TradingStationBlockEntity.setChanged((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (BlockState)pState);
    }

    @Override
    public boolean isWorking() {
        return this.isWorking;
    }

    protected void updateProgress() {
        this.progress += ((Integer)MConfigs.server().tradingStation.progressPerTick.get()).intValue();
        this.setChanged();
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        return this.getRecipe().isPresent();
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public void setRedstoneMode(byte mode) {
        this.currentRedstoneMode = mode;
        this.setChanged();
    }

    @Override
    public byte getCurrentRedstoneMode() {
        return this.currentRedstoneMode;
    }

    @Override
    public byte getRedstoneMode() {
        return this.currentRedstoneMode;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.trading_station.trading_station");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return TradingStationMenu.create(pContainerId, pPlayerInventory, this, this.containerData);
    }

    @Override
    public void sendToMenu(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.getBlockPos());
        buffer.writeNbt((Tag)this.getUpdateTag((HolderLookup.Provider)buffer.registryAccess()));
    }

    @Override
    public void setChangedInternal() {
        this.setChanged();
    }

    @Override
    public final void readClient(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public CompoundTag writeClient(CompoundTag tag, HolderLookup.Provider registries) {
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Override
    public String getMachineId() {
        return "basic";
    }

    @Override
    public void setInputLock(boolean lock) {
        this.inputLocked = lock;
    }

    @Override
    public boolean isLocked() {
        return this.inputLocked;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.writeClient(new CompoundTag(), registries);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readClient(tag, registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readClient(tag == null ? new CompoundTag() : tag, registries);
    }
}

