/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.content.trading_station;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.oierbravo.trading_station.content.trading_recipe.TradingRecipe;
import com.oierbravo.trading_station.content.trading_station.ITradingStationBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class TradingStationBlockRenderer<TSBE extends BlockEntity>
implements BlockEntityRenderer<TSBE> {
    public TradingStationBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntity pBlockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ITradingStationBlockEntity blockEntity;
        if (pBlockEntity instanceof ITradingStationBlockEntity && (blockEntity = (ITradingStationBlockEntity)pBlockEntity).getRecipe().isPresent()) {
            TradingRecipe recipe = (TradingRecipe)blockEntity.getRecipe().get().value();
            pPoseStack.pushPose();
            pPoseStack.translate(0.5, 0.5, 0.5);
            float rot = 0.0f;
            if (blockEntity.isWorking()) {
                rot = ((float)blockEntity.getLevel().getGameTime() + pPartialTick) % 90.0f * 8.0f;
            }
            pPoseStack.mulPose(Axis.YP.rotationDegrees(rot));
            pPoseStack.translate(0.0, 0.7, 0.0);
            this.renderBlock(pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, recipe.getResult(), pBlockEntity);
            pPoseStack.popPose();
        }
    }

    protected void renderBlock(PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack stack, BlockEntity pBlockEntity) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffer, pBlockEntity.getLevel(), 0);
    }
}

