/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.content.trading_station;

import com.oierbravo.mechanicals_ui.foundation.gui.menu.MenuBase;
import com.oierbravo.trading_station.content.trading_station.ITradingStationBlockEntity;
import com.oierbravo.trading_station.registrate.ModMenus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class TradingStationMenu
extends MenuBase<ITradingStationBlockEntity> {
    public final ContainerData containerData;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 2;

    public TradingStationMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        this(type, id, inv, extraData, (ContainerData)new SimpleContainerData(3));
    }

    public TradingStationMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData, ContainerData pData) {
        super(type, id, inv, extraData);
        this.containerData = pData;
        TradingStationMenu.checkContainerSize((Container)inv, (int)3);
        TradingStationMenu.checkContainerDataCount((ContainerData)pData, (int)3);
        this.addDataSlots(this.containerData);
    }

    protected TradingStationMenu(MenuType<?> type, int id, Inventory inv, ITradingStationBlockEntity contentHolder) {
        this(type, id, inv, contentHolder, (ContainerData)new SimpleContainerData(3));
    }

    protected TradingStationMenu(MenuType<?> type, int id, Inventory inv, ITradingStationBlockEntity contentHolder, ContainerData pData) {
        super(type, id, inv, (Object)contentHolder);
        this.containerData = pData;
        TradingStationMenu.checkContainerSize((Container)inv, (int)3);
        TradingStationMenu.checkContainerDataCount((ContainerData)pData, (int)3);
        this.addDataSlots(this.containerData);
    }

    public static TradingStationMenu create(int id, Inventory inv, ITradingStationBlockEntity be, ContainerData containerData) {
        return new TradingStationMenu((MenuType)ModMenus.TRADING_STATION.get(), id, inv, be, containerData);
    }

    protected ITradingStationBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.getInstance().level;
        BlockEntity blockEntity = world.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof ITradingStationBlockEntity) {
            ITradingStationBlockEntity tradingStationBlockEntity = (ITradingStationBlockEntity)blockEntity;
            tradingStationBlockEntity.readClient(extraData.readNbt(), (HolderLookup.Provider)extraData.registryAccess());
            return tradingStationBlockEntity;
        }
        return null;
    }

    protected void initAndReadInventory(ITradingStationBlockEntity iTradingStationBlockEntity) {
    }

    protected void addSlots() {
        this.addPlayerSlots(8, 86);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)((ITradingStationBlockEntity)this.contentHolder).getInputItemHandler(), 0, 20, 38));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)((ITradingStationBlockEntity)this.contentHolder).getInputItemHandler(), 1, 43, 38));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)((ITradingStationBlockEntity)this.contentHolder).getOutputItemHandler(), 0, 132, 38));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)((ITradingStationBlockEntity)this.contentHolder).getTargetItemHandler(), 0, 85, 28));
    }

    protected void saveData(ITradingStationBlockEntity iTradingStationBlockEntity) {
    }

    public boolean isCrafting() {
        return this.containerData.get(0) > 0;
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 38, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 38) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex == 38) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(pPlayer, sourceStack);
        return copyOfSourceStack;
    }
}

