/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.content.trading_station;

import com.oierbravo.mechanicals.foundation.gui.MechanicalGUITextures;
import com.oierbravo.mechanicals.foundation.gui.MechanicalIcons;
import com.oierbravo.mechanicals.foundation.gui.widget.EnergyDisplay;
import com.oierbravo.mechanicals.foundation.gui.widget.IconButton;
import com.oierbravo.mechanicals.foundation.gui.widget.ProgressArrow;
import com.oierbravo.mechanicals.foundation.gui.widget.ToggleIconButton;
import com.oierbravo.mechanicals.foundation.ingredient.CountableIngredient;
import com.oierbravo.mechanicals_ui.foundation.gui.menu.AbstractSimiContainerScreen;
import com.oierbravo.mechanicals_ui.foundation.utility.FakeItemRenderer;
import com.oierbravo.trading_station.ModLang;
import com.oierbravo.trading_station.content.trading_recipe.TradingRecipe;
import com.oierbravo.trading_station.content.trading_station.ITradingStationBlockEntity;
import com.oierbravo.trading_station.content.trading_station.TradingStationMenu;
import com.oierbravo.trading_station.content.trading_station.TradingStationTargetSelectScreen;
import com.oierbravo.trading_station.network.packets.data.LockInputSyncPayload;
import com.oierbravo.trading_station.network.packets.data.RedstoneModeSyncPayload;
import com.oierbravo.trading_station.registrate.ModGuiTextures;
import com.oierbravo.trading_station.registrate.ModMessages;
import com.oierbravo.trading_station.registrate.ModRecipes;
import java.util.Optional;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class TradingStationScreen
extends AbstractSimiContainerScreen<TradingStationMenu> {
    private static final ModGuiTextures BG = ModGuiTextures.TRADING_STATION;
    protected static final MechanicalGUITextures PLAYER = MechanicalGUITextures.PLAYER_INVENTORY;
    protected int imageWidth = 176;
    protected int imageHeight = 176;
    protected byte currentRedstoneMode;
    protected boolean isLocked;
    private IconButton confirmButton;
    private ToggleIconButton lockButton;
    private IconButton targetButton;
    private ToggleIconButton redstoneButton;
    private EnergyDisplay energyInfoArea;
    private ProgressArrow progressArrow;
    private int titleXOffset = 8;
    private int titleYOffset = 6;

    public TradingStationScreen(TradingStationMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.init();
    }

    protected void init() {
        this.setWindowSize(30 + TradingStationScreen.BG.width, TradingStationScreen.BG.height + TradingStationScreen.PLAYER.height - 24);
        this.setWindowOffset(-11, 0);
        super.init();
        this.clearWidgets();
        this.confirmButton = new IconButton(this.leftPos + 30 + TradingStationScreen.BG.width - 33, this.topPos + TradingStationScreen.BG.height - 24, (ScreenElement)MechanicalIcons.CHECK);
        this.confirmButton.withCallback(() -> this.minecraft.player.closeContainer());
        this.confirmButton.setToolTip((Component)ModLang.translate("confirm.button", new Object[0]).component());
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        ScreenElement[] lockButtonIcons = new ScreenElement[]{MechanicalIcons.LOCK_OPEN, MechanicalIcons.LOCK_CLOSE};
        MutableComponent[] lockButtonLabels = new MutableComponent[]{ModLang.translate("screen.lock.lock", new Object[0]).component(), ModLang.translate("screen.lock.unlock", new Object[0]).component()};
        this.isLocked = ((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).isLocked();
        this.lockButton = new ToggleIconButton(this.leftPos + TradingStationScreen.BG.width / 2 - 9, this.topPos + TradingStationScreen.BG.height - 10, lockButtonIcons, lockButtonLabels, this.isLocked ? 1 : 0);
        this.lockButton.withCallback(() -> {
            this.isLocked = !this.isLocked;
            this.lockButton.setCurrentIndex(this.isLocked ? 1 : 0);
            ((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).setInputLock(this.isLocked);
            ModMessages.sendToServer(new LockInputSyncPayload(this.isLocked, ((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).getBlockPos()));
        });
        this.lockButton.setToolTip((Component)ModLang.translate("lock_target.button", new Object[0]).component());
        this.addRenderableWidget((GuiEventListener)this.lockButton);
        this.targetButton = new IconButton(this.leftPos + TradingStationScreen.BG.width / 2 + 10, this.topPos + TradingStationScreen.BG.height - 10, (ScreenElement)MechanicalIcons.SEARCH);
        this.targetButton.withCallback(() -> {
            TradingStationTargetSelectScreen screen = new TradingStationTargetSelectScreen((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder, ((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).getBlockPos());
            Minecraft.getInstance().pushGuiLayer((Screen)screen);
        });
        this.targetButton.setToolTip((Component)ModLang.translate("select_target.button", new Object[0]).component());
        this.addRenderableWidget((GuiEventListener)this.targetButton);
        ScreenElement[] redstoneButtonIcons = new ScreenElement[]{MechanicalIcons.REDSTONE_IGNORE, MechanicalIcons.REDSTONE_LOW, MechanicalIcons.REDSTONE_HIGH};
        MutableComponent[] redstoneButtonLabels = new MutableComponent[]{ModLang.translate("screen.redstone.ignored", new Object[0]).component(), ModLang.translate("screen.redstone.low", new Object[0]).component(), ModLang.translate("screen.redstone.high", new Object[0]).component()};
        this.currentRedstoneMode = ((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).getCurrentRedstoneMode();
        this.redstoneButton = new ToggleIconButton(this.leftPos + 30 + TradingStationScreen.BG.width - 33, this.topPos + TradingStationScreen.BG.height - 40, redstoneButtonIcons, redstoneButtonLabels, (int)this.currentRedstoneMode);
        this.redstoneButton.withCallback(() -> {
            this.currentRedstoneMode = (byte)(this.currentRedstoneMode == 2 ? 0 : this.currentRedstoneMode + 1);
            ((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).setRedstoneMode(this.currentRedstoneMode);
            this.redstoneButton.setCurrentIndex((int)this.currentRedstoneMode);
            ModMessages.sendToServer(new RedstoneModeSyncPayload(this.currentRedstoneMode, ((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).getBlockPos()));
        });
        this.addRenderableWidget((GuiEventListener)this.redstoneButton);
        if (((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).getEnergyStorageHandler() != null) {
            this.energyInfoArea = new EnergyDisplay(this.leftPos + 30 + TradingStationScreen.BG.width - 50, this.topPos + TradingStationScreen.BG.height - 40, ((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).getEnergyStorageHandler());
            this.addRenderableWidget((GuiEventListener)this.energyInfoArea);
        }
        this.progressArrow = new ProgressArrow(this.leftPos + TradingStationScreen.BG.width / 2 - 8, this.topPos + TradingStationScreen.BG.height / 2 + 13);
        this.addRenderableWidget((GuiEventListener)this.progressArrow);
    }

    protected void drawExclamation(GuiGraphics pGuiGraphics, int pX, int pY) {
        MechanicalIcons exclamationElement = MechanicalIcons.TRIANGLE_EXCLAMATION_ORANGE;
        exclamationElement.render(pGuiGraphics, pX, pY);
    }

    protected void containerTick() {
        this.progressArrow.setProgress(((TradingStationMenu)this.menu).containerData.get(0), ((TradingStationMenu)this.menu).containerData.get(1));
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        Optional<RecipeHolder<?>> recipeHolder;
        int x = this.leftPos + this.imageWidth - TradingStationScreen.BG.width;
        int y = this.topPos;
        BG.render(pGuiGraphics, x, y);
        pGuiGraphics.drawString(this.font, this.title, x + this.titleXOffset, y + 4, 5841956, false);
        int invX = this.leftPos;
        int invY = this.topPos + this.imageHeight - TradingStationScreen.PLAYER.height;
        this.renderPlayerInventory(pGuiGraphics, invX, invY);
        if (!((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).getTargetedRecipeId().isEmpty() && (recipeHolder = ModRecipes.findById(((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).getLevel(), ((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).getTargetedRecipeId())).isPresent()) {
            TradingRecipe recipe = (TradingRecipe)recipeHolder.get().value();
            for (int index = 0; index < recipe.getIngredients().size(); ++index) {
                CountableIngredient ingredient = (CountableIngredient)recipe.getCountableIngredients().get(index);
                if (ingredient.ingredient().isEmpty()) continue;
                FakeItemRenderer.renderFakeItem((GuiGraphics)pGuiGraphics, (ItemStack)ingredient.ingredient().getItems()[0], (int)(this.leftPos + 20 + 23 * index), (int)(this.topPos + 38), (boolean)true, (boolean)false);
                ItemStack slotStack = ((ITradingStationBlockEntity)((TradingStationMenu)this.menu).contentHolder).getInputItemHandler().getStackInSlot(index);
                if (!slotStack.isEmpty() && slotStack.is(ingredient.ingredient().getItems()[0].getItem())) continue;
                this.drawExclamation(pGuiGraphics, this.leftPos + 20 + 23 * index, this.topPos + 20);
            }
        }
    }
}

