/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.content.trading_station;

import com.mojang.blaze3d.systems.RenderSystem;
import com.oierbravo.mechanicals.foundation.gui.MechanicalIcons;
import com.oierbravo.mechanicals.foundation.gui.widget.IconButton;
import com.oierbravo.trading_station.ModLang;
import com.oierbravo.trading_station.content.trading_recipe.TradingRecipe;
import com.oierbravo.trading_station.content.trading_station.ITradingStationBlockEntity;
import com.oierbravo.trading_station.foundation.component.TradingRecipeComponent;
import com.oierbravo.trading_station.network.packets.data.RecipeClearSyncPayload;
import com.oierbravo.trading_station.network.packets.data.RecipeSelectSyncPayload;
import com.oierbravo.trading_station.registrate.ModGuiTextures;
import com.oierbravo.trading_station.registrate.ModItemComponents;
import com.oierbravo.trading_station.registrate.ModMessages;
import com.oierbravo.trading_station.registrate.ModRecipes;
import java.util.LinkedList;
import java.util.List;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TradingStationTargetSelectScreen
extends AbstractSimiScreen {
    private static final ModGuiTextures BG = ModGuiTextures.TRADING_SELECT;
    private ITradingStationBlockEntity blockEntity;
    private List<RecipeHolder<TradingRecipe>> allPossibleRecipes;
    private LinkedList<RecipeHolder<TradingRecipe>> displayedRecipes = new LinkedList();
    private float scrollOffset;
    private boolean scrolling;
    private int startIndex;
    private static int MAX_DISPLAYED_RECIPES = 24;
    private static final int COLUMNS = 8;
    private static final int TARGET_BOX_SIZE = 17;
    private int targetBoxLeftPosOffset = 7;
    private int targetBoxTopPosOffset = 19;
    private int scrollBarXOffset = 148;
    private int scrollBarYOffset = 22;
    protected int titleLabelX;
    protected int titleLabelY;
    protected int imageWidth = 165;
    protected int imageHeight = 83;
    protected int leftPos;
    protected int topPos;
    private BlockPos blockPos;
    private IconButton backButton;
    private IconButton clearButton;

    protected TradingStationTargetSelectScreen(Component pTitle) {
        super(pTitle);
    }

    public TradingStationTargetSelectScreen(ITradingStationBlockEntity pBlockEntity, BlockPos pBlockPos) {
        this((Component)ModLang.translate("select_target.title", new Object[0]).component());
        this.blockEntity = pBlockEntity;
        this.blockPos = pBlockPos;
        this.allPossibleRecipes = ModRecipes.getAllRecipesForMachine(pBlockEntity.getLevel(), (BlockEntity)pBlockEntity);
        this.resetDisplayedTargets();
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    protected void init() {
        super.init();
        this.titleLabelX = 4;
        this.titleLabelY = 4;
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.backButton = new IconButton(this.getGuiLeft() - 20, this.getGuiTop() + 1, (ScreenElement)MechanicalIcons.ARROW_LEFT);
        this.backButton.withCallback(() -> Minecraft.getInstance().popGuiLayer());
        this.backButton.setToolTip((Component)ModLang.translate("select_target.back", new Object[0]).component());
        this.addRenderableWidget((GuiEventListener)this.backButton);
        this.clearButton = new IconButton(this.getGuiLeft() - 20, this.getGuiTop() + 30, (ScreenElement)MechanicalIcons.TRASH);
        this.clearButton.withCallback(() -> {
            ModMessages.sendToServer(new RecipeClearSyncPayload(this.getBlockPos()));
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
            Minecraft.getInstance().popGuiLayer();
        });
        this.clearButton.setToolTip((Component)ModLang.translate("select_target.clear", new Object[0]).component());
        this.addRenderableWidget((GuiEventListener)this.clearButton);
    }

    public int getGuiLeft() {
        return this.leftPos - 25;
    }

    public int getGuiTop() {
        return this.topPos;
    }

    public void tick() {
        if (this.displayedRecipes.size() < MAX_DISPLAYED_RECIPES) {
            this.mouseScrolled(0.0, 0.0, 0.0);
            this.scrollOffset = 0.0f;
        }
        if (this.displayedRecipes.size() <= MAX_DISPLAYED_RECIPES) {
            this.startIndex = 0;
            this.scrollOffset = 0.0f;
        }
        super.tick();
    }

    protected void renderWindowForeground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int lastDisplayedIndex = this.startIndex + MAX_DISPLAYED_RECIPES;
        this.renderScrollbar(pGuiGraphics);
        this.renderSelectedRecipe(pGuiGraphics, pMouseX, pMouseY, lastDisplayedIndex);
        this.renderRecipe(pGuiGraphics, pMouseX, pMouseY, lastDisplayedIndex);
        this.renderLabels(pGuiGraphics, pMouseX, pMouseY);
        super.renderWindowForeground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void renderWindowBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.drawString(this.font, this.title.getString(), (float)this.titleLabelX + (float)this.getGuiLeft(), (float)this.titleLabelY + (float)this.getGuiTop(), 0x404040, false);
    }

    private void renderSelectedRecipe(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int pLastDisplayedIndex) {
        LinkedList<RecipeHolder<TradingRecipe>> displayedRecipes = this.getDisplayedRecipes();
        for (int index = this.startIndex; index >= 0 && index < pLastDisplayedIndex && index < displayedRecipes.size(); ++index) {
            int firstDisplayedIndex = index - this.startIndex;
            ResourceLocation targetId = this.allPossibleRecipes.get(index).id();
            int xStart = this.getGuiLeft() + this.targetBoxLeftPosOffset + firstDisplayedIndex % 8 * 17 + 1;
            int yStart = this.getGuiTop() + this.targetBoxTopPosOffset + firstDisplayedIndex / 8 * 17 + 3;
            if (!targetId.toString().equals(this.blockEntity.getTargetedRecipeId())) continue;
            ModGuiTextures.TRADING_SELECT_SELECTED.render(pGuiGraphics, xStart, yStart);
        }
    }

    private void renderRecipe(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int pLastDisplayedIndex) {
        LinkedList<RecipeHolder<TradingRecipe>> displayedRecipes = this.getDisplayedRecipes();
        for (int index = this.startIndex; index >= 0 && index < pLastDisplayedIndex && index < displayedRecipes.size(); ++index) {
            int firstDisplayedIndex = index - this.startIndex;
            TradingRecipe target = (TradingRecipe)this.allPossibleRecipes.get(index).value();
            ResourceLocation targetId = this.allPossibleRecipes.get(index).id();
            int xStart = this.getGuiLeft() + this.targetBoxLeftPosOffset + firstDisplayedIndex % 8 * 17 + 1;
            int yStart = this.getGuiTop() + this.targetBoxTopPosOffset + firstDisplayedIndex / 8 * 17 + 3;
            this.renderFloatingItem(pGuiGraphics, target.getResult(), xStart, yStart);
            if (pMouseX < xStart - 1 || pMouseX > xStart + 16 || pMouseY < yStart - 1 || pMouseY > yStart + 16) continue;
            ItemStack result = target.getResult();
            result.set(ModItemComponents.TRADING_RECIPE_ID, (Object)new TradingRecipeComponent(targetId));
            pGuiGraphics.renderTooltip(this.font, result, pMouseX, pMouseY);
        }
    }

    private LinkedList<RecipeHolder<TradingRecipe>> getDisplayedRecipes() {
        return this.displayedRecipes;
    }

    private void renderFloatingItem(GuiGraphics pGuiGraphics, ItemStack pItemStack, int pX, int pY) {
        RenderSystem.applyModelViewMatrix();
        pGuiGraphics.renderFakeItem(pItemStack, pX, pY);
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pGuiGraphics.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        BG.render(pGuiGraphics, this.getGuiLeft(), this.getGuiTop());
    }

    private void renderScrollbar(GuiGraphics pGuiGraphics) {
        int scrollPosition = (int)(43.0f * this.scrollOffset);
        if (this.isScrollBarActive()) {
            ModGuiTextures.TRADING_SELECT_SCROLL_ACTIVE.render(pGuiGraphics, this.getGuiLeft() + this.scrollBarXOffset, this.getGuiTop() + this.scrollBarYOffset + scrollPosition);
        } else {
            ModGuiTextures.TRADING_SELECT_SCROLL_INACTIVE.render(pGuiGraphics, this.getGuiLeft() + this.scrollBarXOffset, this.getGuiTop() + this.scrollBarYOffset + scrollPosition);
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        int lastDisplayedIndex = this.startIndex + MAX_DISPLAYED_RECIPES;
        for (int index = this.startIndex; index < lastDisplayedIndex; ++index) {
            int currentIndex = index - this.startIndex;
            double boxX = pMouseX - (double)(this.getGuiLeft() + this.targetBoxLeftPosOffset + currentIndex % 8 * 17);
            double boxY = pMouseY - (double)(this.getGuiTop() + this.targetBoxTopPosOffset + currentIndex / 8 * 17);
            if (boxX > 0.0 && boxX <= 18.0 && boxY > 0.0 && boxY <= 18.0 && this.isValidRecipeIndex(index)) {
                ResourceLocation recipeId = this.getDisplayedRecipes().get(index).id();
                ModMessages.sendToServer(new RecipeSelectSyncPayload(recipeId, this.getBlockPos()));
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                Minecraft.getInstance().popGuiLayer();
                return true;
            }
            int scrollMinX = this.getGuiLeft() + 148;
            int scrollMinY = this.getGuiTop() + 9;
            int scrollMaxX = scrollMinX + 6;
            int scrollMaxY = scrollMinY + 60;
            if (!(pMouseX >= (double)scrollMinX) || !(pMouseX < (double)scrollMaxX) || !(pMouseY >= (double)scrollMinY) || !(pMouseY < (double)scrollMaxY)) continue;
            this.scrolling = true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    private boolean isValidRecipeIndex(int pSlot) {
        return pSlot >= 0 && pSlot < this.getDisplayedRecipes().size();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void resetDisplayedTargets() {
        this.displayedRecipes.clear();
        this.displayedRecipes.addAll(this.allPossibleRecipes);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int scrollbarTopPos = this.getGuiTop() + 9;
            int scrollbarBottomPos = scrollbarTopPos + 51;
            this.scrollOffset = ((float)pMouseY - (float)scrollbarTopPos - 7.5f) / ((float)(scrollbarBottomPos - scrollbarTopPos) - 9.0f);
            this.scrollOffset = Mth.clamp((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)this.getOffscreenRows()) + 0.5) * 8;
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta) {
        if (pMouseX >= (double)this.getGuiLeft() && pMouseX < (double)(this.getGuiLeft() + this.imageWidth) && pMouseY >= (double)this.getGuiTop() && pMouseY < (double)(this.getGuiTop() + this.imageHeight) && this.isScrollBarActive()) {
            this.scrollOffset = Mth.clamp((float)(this.scrollOffset - (float)pDelta / (float)this.getOffscreenRows()), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)this.getOffscreenRows()) + 0.5) * 8;
        }
        return true;
    }

    private int getOffscreenRows() {
        return (this.displayedRecipes.size() + 6 - 1) / 6 - 3;
    }

    private boolean isScrollBarActive() {
        return this.displayedRecipes.size() > MAX_DISPLAYED_RECIPES;
    }
}

