/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.content.trading_station.powered;

import com.oierbravo.mechanicals.foundation.energy.AbstractEnergyStorage;
import com.oierbravo.trading_station.content.trading_station.TradingStationBlock;
import com.oierbravo.trading_station.content.trading_station.TradingStationBlockEntity;
import com.oierbravo.trading_station.infrastructure.config.MConfigs;
import com.oierbravo.trading_station.registrate.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class PoweredTradingStationBlockEntity
extends TradingStationBlockEntity {
    private final AbstractEnergyStorage energyStorage = this.createEnergyStorage();

    public PoweredTradingStationBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    private AbstractEnergyStorage createEnergyStorage() {
        return new AbstractEnergyStorage((Integer)MConfigs.server().poweredTradingStation.energyCapacity.get(), (Integer)MConfigs.server().poweredTradingStation.energyTransfer.get()){

            public void onEnergyChanged() {
                PoweredTradingStationBlockEntity.this.setChanged();
                PoweredTradingStationBlockEntity.this.getLevel().sendBlockUpdated(PoweredTradingStationBlockEntity.this.getBlockPos(), PoweredTradingStationBlockEntity.this.getBlockState(), PoweredTradingStationBlockEntity.this.getBlockState(), 3);
            }
        };
    }

    @Override
    public IEnergyStorage getEnergyStorageHandler() {
        return this.energyStorage;
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        this.invalidateCapabilities();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.POWERED_TRADING_STATION_BLOCK_ENTITY.get(), (be, context) -> {
            Direction localDir = (Direction)be.getBlockState().getValue((Property)TradingStationBlock.HORIZONTAL_FACING);
            if (context != null && localDir == context.getCounterClockWise()) {
                return be.getInputItemHandler();
            }
            if (context != null && localDir == context.getClockWise()) {
                return be.getOutputItemHandler();
            }
            if (context == null) {
                return null;
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntities.POWERED_TRADING_STATION_BLOCK_ENTITY.get(), (be, context) -> be.getEnergyStorageHandler());
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("energy", this.energyStorage.getEnergyStored());
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.energyStorage.setEnergy(tag.getInt("energy"));
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"block.trading_station.powered_trading_station");
    }

    @Override
    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        super.tick(pLevel, pPos, pState);
    }

    @Override
    protected void updateProgress() {
        this.progress += ((Integer)MConfigs.server().poweredTradingStation.progressPerTick.get()).intValue();
        this.extractEnergy();
    }

    private void extractEnergy() {
        this.energyStorage.extractEnergy(((Integer)MConfigs.server().poweredTradingStation.energyPerTick.get()).intValue(), false);
    }

    @Override
    public boolean canCraftItem() {
        Level level = this.getLevel();
        if (level == null) {
            return false;
        }
        if (this.energyStorage.getEnergyStored() < (Integer)MConfigs.server().poweredTradingStation.energyPerTick.get()) {
            return false;
        }
        return super.canCraftItem();
    }

    @Override
    public String getMachineId() {
        return "powered";
    }
}

