/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.trading_station.foundation.gui;

import com.oierbravo.mechanicals.foundation.ingredient.CountableIngredient;
import com.oierbravo.mechanicals_ui.foundation.utility.FakeItemRenderer;
import com.oierbravo.trading_station.content.trading_recipe.TradingRecipe;
import java.util.concurrent.atomic.AtomicInteger;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record TradingRecipeTooltipComponent(TradingRecipe tradingRecipe) implements TooltipComponent,
ClientTooltipComponent
{
    private static int LINE_HEIGHT = 10;

    public int getHeight() {
        return 20 + this.tradingRecipe.getRecipeRequirements().size() * LINE_HEIGHT;
    }

    public int getWidth(Font font) {
        return 190;
    }

    public void renderImage(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
        for (int index = 0; index < this.tradingRecipe.getCountableIngredients().size(); ++index) {
            CountableIngredient ingredient = (CountableIngredient)this.tradingRecipe.getCountableIngredients().get(index);
            if (ingredient.ingredient().isEmpty()) continue;
            FakeItemRenderer.renderFakeItem((GuiGraphics)pGuiGraphics, (ItemStack)new ItemStack((ItemLike)ingredient.ingredient().getItems()[0].getItem(), ingredient.count()), (int)(pX + index * 20), (int)pY, (boolean)false, (boolean)true);
        }
        Font font = Minecraft.getInstance().font;
        AtomicInteger yOffset = new AtomicInteger(18);
        this.tradingRecipe.getRecipeRequirements().forEach(recipeRequirement -> {
            pGuiGraphics.drawString(font, recipeRequirement.toItemTooltipComponent(), pX, pY + yOffset.get(), Color.WHITE.getRGB(), false);
            yOffset.addAndGet(LINE_HEIGHT);
        });
    }
}

