/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AccessCommand {
    public AccessCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.literal((String)"tb").requires(player -> player.hasPermission(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.literal((String)"access").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(source -> this.openTargetBlockEntity((CommandSourceStack)source.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)source, (String)"pos"))))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(source -> this.openTargetInventory((CommandSourceStack)source.getSource(), EntityArgument.getPlayer((CommandContext)source, (String)"target")))));
        dispatcher.register(tbCommand);
    }

    public int openTargetBlockEntity(CommandSourceStack source, BlockPos blockPos) throws CommandSyntaxException {
        BlockEntity blockEntity = source.getLevel().getBlockEntity(blockPos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            backpackBlockEntity.openBackpackFromCommand((Player)source.getPlayerOrException(), backpackBlockEntity, blockPos);
            source.sendSuccess(() -> Component.literal((String)("Accessing backpack of " + blockPos.toShortString())), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)("There's no backpack at coordinates " + blockPos.toShortString())));
        return -1;
    }

    public int openTargetInventory(CommandSourceStack source, ServerPlayer target) throws CommandSyntaxException {
        ServerPlayer self = source.getPlayerOrException();
        boolean hasBackpack = AttachmentUtils.isWearingBackpack((Player)target);
        ItemStack stack = AttachmentUtils.getWearingBackpack((Player)target);
        if (hasBackpack) {
            BackpackContainer.openAnotherPlayerBackpack(self, target, stack, 2);
            source.sendSuccess(() -> Component.literal((String)("Accessing backpack of " + target.getDisplayName().getString())), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Can't access backpack"));
        return -1;
    }
}

