/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Nautilus;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NautilusModel<T extends Nautilus>
extends EntityModel<T> {
    public ModelPart shell;
    public ModelPart head;
    public ModelPart Shell2;
    public ModelPart tents_top;
    public ModelPart hood;
    public ModelPart tents_bottom;
    public ModelPart tents_right;
    public ModelPart tents_left;

    public NautilusModel(ModelPart root) {
        this.shell = root.getChild("shell");
        this.Shell2 = this.shell.getChild("Shell2");
        this.head = this.shell.getChild("head");
        this.hood = this.head.getChild("hood");
        this.tents_top = this.head.getChild("tents_top");
        this.tents_left = this.head.getChild("tents_left");
        this.tents_right = this.head.getChild("tents_right");
        this.tents_bottom = this.head.getChild("tents_bottom");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition shell = root.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(28, 14).addBox(-3.0f, -6.0f, -6.0f, 6.0f, 6.0f, 12.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.08726646f, (float)0.0f, (float)0.0f));
        PartDefinition Shell2 = shell.addOrReplaceChild("Shell2", CubeListBuilder.create().texOffs(0, 18).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 6.0f, 8.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = shell.addOrReplaceChild("head", CubeListBuilder.create().texOffs(15, 0).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)3.1f, (float)4.0f, (float)-0.1308997f, (float)0.0f, (float)0.0f));
        PartDefinition hood = head.addOrReplaceChild("hood", CubeListBuilder.create().texOffs(35, 0).addBox(-3.5f, -0.5f, 0.0f, 7.0f, 1.0f, 7.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tents_top = head.addOrReplaceChild("tents_top", CubeListBuilder.create().texOffs(16, 11).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tents_left = head.addOrReplaceChild("tents_left", CubeListBuilder.create().texOffs(26, 11).addBox(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 4.0f, false), PartPose.offsetAndRotation((float)-2.5f, (float)0.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tents_right = head.addOrReplaceChild("tents_right", CubeListBuilder.create().texOffs(21, 11).addBox(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 4.0f, false), PartPose.offsetAndRotation((float)2.5f, (float)0.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tents_bottom = head.addOrReplaceChild("tents_bottom", CubeListBuilder.create().texOffs(26, 11).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.shell.render(matrixStack, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    public void setupAnim(T nautilus, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean moving = ((Nautilus)((Object)nautilus)).isMoving();
        boolean inWater = nautilus.isInWater();
        float shellSway = !inWater || moving ? 1.5f : 1.0f;
        this.tents_left.yRot = -shellSway * 0.1f * Mth.cos((float)(0.2f * ageInTicks));
        this.tents_right.yRot = -shellSway * 0.1f * -Mth.cos((float)(0.2f * ageInTicks));
        this.tents_top.xRot = -shellSway * 0.1f * Mth.sin((float)(0.2f * ageInTicks));
        this.tents_bottom.xRot = -shellSway * 0.1f * -Mth.sin((float)(0.2f * ageInTicks));
        if (moving && nautilus.isInWater()) {
            this.shell.xRot = -0.12f * Mth.sin((float)(0.2f * ageInTicks));
        }
    }
}

