/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class PerchModel<T extends Entity>
extends ListModel<T> {
    public ModelPart perch;
    public ModelPart body;
    public ModelPart sidefin1;
    public ModelPart sidefin2;
    public ModelPart frontfin1;
    public ModelPart frontfin2;
    public ModelPart backfin1;
    public ModelPart backfin2;

    public PerchModel(ModelPart root) {
        this.perch = root.getChild("perch");
        this.body = this.perch.getChild("body");
        this.sidefin1 = this.body.getChild("sidefin1");
        this.sidefin2 = this.body.getChild("sidefin2");
        this.frontfin1 = this.body.getChild("frontfin1");
        this.frontfin2 = this.body.getChild("frontfin2");
        this.backfin1 = this.body.getChild("backfin1");
        this.backfin2 = this.body.getChild("backfin2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition perch = root.addOrReplaceChild("perch", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)22.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = perch.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -5.0f, -4.0f, 2.0f, 5.0f, 11.0f, false).texOffs(15, 0).addBox(-1.0f, -3.0f, -7.0f, 2.0f, 3.0f, 3.0f, false).texOffs(0, 7).addBox(0.0f, -8.0f, -2.0f, 0.0f, 3.0f, 9.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition sidefin1 = body.addOrReplaceChild("sidefin1", CubeListBuilder.create().texOffs(15, 2).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)-2.0f, (float)-4.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition sidefin2 = body.addOrReplaceChild("sidefin2", CubeListBuilder.create().texOffs(15, 2).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)-4.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition frontfin1 = body.addOrReplaceChild("frontfin1", CubeListBuilder.create().texOffs(0, 15).addBox(-0.0872f, 0.0f, -1.0038f, 0.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition frontfin2 = body.addOrReplaceChild("frontfin2", CubeListBuilder.create().texOffs(0, 15).addBox(0.0872f, 0.0f, -1.0038f, 0.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition backfin1 = body.addOrReplaceChild("backfin1", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, 0.0f, -2.0f, 0.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition backfin2 = body.addOrReplaceChild("backfin2", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.perch, (Object)this.body, (Object)this.sidefin1, (Object)this.sidefin2, (Object)this.frontfin1, (Object)this.frontfin2, (Object)this.backfin1, (Object)this.backfin2);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = !entityIn.isInWater() ? 1.5f : 1.0f;
        this.backfin2.yRot = -f * 0.45f * Mth.sin((float)(0.6f * ageInTicks));
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.perch.render(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

