/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.model.jellyfish;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import com.teamabnormals.blueprint.core.endimator.EndimatorModelPart;
import com.teamabnormals.blueprint.core.endimator.entity.EndimatorEntityModel;
import com.teamabnormals.blueprint.core.endimator.model.EndimatorLayerDefinition;
import com.teamabnormals.blueprint.core.endimator.model.EndimatorPartDefinition;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.ImmortalJellyfish;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.util.Mth;

public class ImmortalJellyfishModel<E extends ImmortalJellyfish>
extends EndimatorEntityModel<E> {
    public EndimatorModelPart body;
    public EndimatorModelPart innerBody;
    public EndimatorModelPart tentacleEast;
    public EndimatorModelPart tentacleWest;
    public EndimatorModelPart bottomBody;
    public EndimatorModelPart tentacleSouth;
    public EndimatorModelPart tentacleNorth;
    public EndimatorModelPart tentacleSouthEast;
    public EndimatorModelPart tentacleSouthWest;
    public EndimatorModelPart tentacleNorthEast;
    public EndimatorModelPart tentacleNorthWest;

    public ImmortalJellyfishModel(ModelPart root) {
        this.body = (EndimatorModelPart)root.getChild("body");
        this.innerBody = (EndimatorModelPart)root.getChild("innerBody");
        this.tentacleEast = (EndimatorModelPart)this.body.getChild("tentacleEast");
        this.tentacleWest = (EndimatorModelPart)this.body.getChild("tentacleWest");
        this.bottomBody = (EndimatorModelPart)this.body.getChild("bottomBody");
        this.tentacleSouth = (EndimatorModelPart)this.body.getChild("tentacleSouth");
        this.tentacleNorth = (EndimatorModelPart)this.body.getChild("tentacleNorth");
        this.tentacleSouthEast = (EndimatorModelPart)this.body.getChild("tentacleSouthEast");
        this.tentacleSouthWest = (EndimatorModelPart)this.body.getChild("tentacleSouthWest");
        this.tentacleNorthEast = (EndimatorModelPart)this.body.getChild("tentacleNorthEast");
        this.tentacleNorthWest = (EndimatorModelPart)this.body.getChild("tentacleNorthWest");
        this.body.setShouldScaleChildren(false);
        this.endimator = Endimator.compile((ModelPart)root);
    }

    public static EndimatorLayerDefinition createBodyLayer() {
        EndimatorPartDefinition root = EndimatorPartDefinition.root();
        EndimatorPartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 28).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 7.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition innerBody = root.addOrReplaceChild("innerBody", CubeListBuilder.create().texOffs(18, 0).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition tentacleEast = body.addOrReplaceChild("tentacleEast", CubeListBuilder.create().addBox(-8.0f, 0.0f, 0.0f, 8.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)-3.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.43633232f));
        EndimatorPartDefinition tentacleWest = body.addOrReplaceChild("tentacleWest", CubeListBuilder.create().addBox(-8.0f, 0.0f, 0.0f, 8.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)3.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI), (float)-0.43633232f));
        EndimatorPartDefinition bottomBody = body.addOrReplaceChild("bottomBody", CubeListBuilder.create().texOffs(0, 15).addBox(-5.0f, -1.0f, -5.0f, 10.0f, 1.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition tentacleSouth = body.addOrReplaceChild("tentacleSouth", CubeListBuilder.create().texOffs(0, -8).addBox(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)3.2f, (float)0.43633232f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition tentacleNorth = body.addOrReplaceChild("tentacleNorth", CubeListBuilder.create().texOffs(0, -8).addBox(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-3.2f, (float)0.43633232f, (float)((float)Math.PI), (float)0.0f));
        EndimatorPartDefinition tentacleSouthEast = body.addOrReplaceChild("tentacleSouthEast", CubeListBuilder.create().texOffs(0, -8).addBox(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)3.4f, (float)3.8f, (float)3.4f, (float)0.43633232f, (float)0.7853982f, (float)0.0f));
        EndimatorPartDefinition tentacleSouthWest = body.addOrReplaceChild("tentacleSouthWest", CubeListBuilder.create().texOffs(0, -8).addBox(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)-3.4f, (float)3.8f, (float)3.4f, (float)0.43633232f, (float)-0.7853982f, (float)0.0f));
        EndimatorPartDefinition tentacleNorthEast = body.addOrReplaceChild("tentacleNorthEast", CubeListBuilder.create().texOffs(0, -8).addBox(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)-3.4f, (float)3.8f, (float)-3.4f, (float)0.43633232f, (float)-2.3561945f, (float)0.0f));
        EndimatorPartDefinition tentacleNorthWest = body.addOrReplaceChild("tentacleNorthWest", CubeListBuilder.create().texOffs(0, -8).addBox(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)3.4f, (float)3.8f, (float)-3.4f, (float)0.43633232f, (float)2.3561945f, (float)0.0f));
        return new EndimatorLayerDefinition(root, 64, 64);
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.innerBody.render(matrixStackIn, bufferIn, 240, packedOverlayIn, color);
        this.body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float tentacleAngle;
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float amplifier = Math.min(limbSwingAmount, 0.25f) * 4.0f;
        float progress = Mth.sin((float)limbSwing) * amplifier;
        this.tentacleNorth.xRot = tentacleAngle = 0.45f * progress;
        this.tentacleNorthEast.xRot = tentacleAngle;
        this.tentacleNorthWest.xRot = tentacleAngle;
        this.tentacleSouth.xRot = tentacleAngle;
        this.tentacleSouthEast.xRot = tentacleAngle;
        this.tentacleSouthWest.xRot = -tentacleAngle;
        this.tentacleEast.zRot = tentacleAngle;
        this.tentacleWest.zRot = tentacleAngle;
        progress = Mth.abs((float)progress);
        float xzScale = 1.0f + 0.15f * progress;
        float yScale = 1.0f - 0.25f * progress;
        this.body.setScale(xzScale, yScale, xzScale);
        this.body.setOffset(0.0f, 0.041666668f * progress, 0.0f);
        this.innerBody.setScale(xzScale, yScale, xzScale);
        this.innerBody.y = 20.0f + 1.5f * progress;
    }
}

